/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerOptions
implements Serializable,
Cloneable {
    private boolean manageClosureDependencies = false;
    private static final long serialVersionUID = 7L;
    private LanguageMode languageIn;
    private LanguageMode languageOut;
    boolean acceptConstKeyword = false;
    private boolean assumeStrictThis = false;
    public boolean ideMode;
    boolean saveDataStructures = false;
    boolean inferTypes;
    boolean skipAllPasses = false;
    boolean nameAnonymousFunctionsOnly = false;
    DevMode devMode;
    DependencyOptions dependencyOptions = new DependencyOptions();
    public transient MessageBundle messageBundle = null;
    public boolean checkSymbols = false;
    public CheckLevel aggressiveVarCheck;
    public boolean checkSuspiciousCode = false;
    public boolean checkControlStructures = false;
    public boolean checkTypes = false;
    boolean tightenTypes = false;
    public CheckLevel reportMissingOverride;
    CheckLevel reportUnknownTypes;
    public CheckLevel checkRequires;
    public CheckLevel checkProvides;
    public CheckLevel checkGlobalNamesLevel;
    public CheckLevel brokenClosureRequiresLevel;
    public CheckLevel checkGlobalThisLevel;
    public CheckLevel checkMissingGetCssNameLevel;
    public String checkMissingGetCssNameBlacklist = null;
    boolean checkCaja = false;
    Set<String> extraAnnotationNames = null;
    public boolean foldConstants = false;
    public boolean deadAssignmentElimination = false;
    public boolean inlineConstantVars = false;
    public boolean inlineFunctions = false;
    public boolean inlineLocalFunctions = false;
    boolean inlineProperties = false;
    public boolean crossModuleCodeMotion = false;
    public boolean coalesceVariableNames = false;
    public boolean crossModuleMethodMotion = false;
    public boolean inlineGetters = false;
    public boolean inlineVariables = false;
    boolean inlineLocalVariables = false;
    public boolean flowSensitiveInlineVariables;
    public boolean smartNameRemoval = false;
    public boolean removeDeadCode = false;
    public CheckLevel checkUnreachableCode;
    public CheckLevel checkMissingReturn;
    public boolean extractPrototypeMemberDeclarations = false;
    public boolean removeUnusedPrototypeProperties = false;
    public boolean removeUnusedPrototypePropertiesInExterns = false;
    public boolean removeUnusedClassProperties = false;
    public boolean removeUnusedVars = false;
    public boolean removeUnusedLocalVars = false;
    public boolean aliasExternals = false;
    String aliasableGlobals;
    String unaliasableGlobals;
    public boolean collapseVariableDeclarations = false;
    boolean groupVariableDeclarations = false;
    public boolean collapseAnonymousFunctions = false;
    public Set<String> aliasableStrings;
    public String aliasStringsBlacklist = "";
    public boolean aliasAllStrings = false;
    boolean outputJsStringUsage = false;
    public boolean convertToDottedProperties = false;
    public boolean rewriteFunctionExpressions = false;
    public boolean optimizeParameters = false;
    public boolean optimizeReturns = false;
    public boolean optimizeCalls;
    public boolean optimizeArgumentsArray;
    boolean chainCalls = false;
    public VariableRenamingPolicy variableRenaming;
    public PropertyRenamingPolicy propertyRenaming;
    boolean propertyAffinity = false;
    public boolean labelRenaming = false;
    public boolean reserveRawExports;
    boolean shadowVariables = false;
    public boolean generatePseudoNames = false;
    public String renamePrefix = null;
    public String renamePrefixNamespace;
    public boolean aliasKeywords = false;
    public boolean collapseProperties = false;
    boolean collapseObjectLiterals = false;
    boolean collapsePropertiesOnExternTypes = false;
    public boolean devirtualizePrototypeMethods = false;
    public boolean computeFunctionSideEffects = false;
    String debugFunctionSideEffectsPath = null;
    public boolean disambiguateProperties = false;
    public boolean ambiguateProperties = false;
    public AnonymousFunctionNamingPolicy anonymousFunctionNaming;
    VariableMap inputAnonymousFunctionNamingMap;
    VariableMap inputVariableMap;
    VariableMap inputPropertyMap;
    public boolean exportTestFunctions = false;
    boolean specializeInitialModule;
    boolean replaceMessagesWithChromeI18n;
    String tcProjectId;
    boolean runtimeTypeCheck = false;
    String runtimeTypeCheckLogFunction = null;
    private CodingConvention codingConvention;
    boolean ignoreCajaProperties = false;
    public String syntheticBlockStartMarker = null;
    public String syntheticBlockEndMarker = null;
    public String locale = null;
    public boolean markAsCompiled = false;
    public boolean removeTryCatchFinally = false;
    public boolean closurePass = false;
    public boolean jqueryPass = false;
    boolean removeAbstractMethods = true;
    boolean removeClosureAsserts = false;
    public boolean gatherCssNames;
    public Set<String> stripTypes;
    public Set<String> stripNameSuffixes;
    public Set<String> stripNamePrefixes;
    public Set<String> stripTypePrefixes;
    public transient Multimap<CustomPassExecutionTime, CompilerPass> customPasses = null;
    public boolean markNoSideEffectCalls = false;
    private Map<String, Object> defineReplacements;
    private TweakProcessing tweakProcessing;
    private Map<String, Object> tweakReplacements;
    public boolean moveFunctionDeclarations = false;
    public String instrumentationTemplate = null;
    String appNameStr = "";
    public boolean recordFunctionInformation = false;
    public boolean generateExports = false;
    public CssRenamingMap cssRenamingMap = null;
    Set<String> cssRenamingWhitelist = null;
    boolean processObjectPropertyString = false;
    boolean replaceIdGenerators = true;
    Set<String> idGenerators;
    String idGeneratorsMapSerialized;
    List<String> replaceStringsFunctionDescriptions;
    String replaceStringsPlaceholderToken = "";
    Set<String> replaceStringsReservedStrings;
    VariableMap replaceStringsInputMap;
    Map<String, CheckLevel> propertyInvalidationErrors;
    boolean transformAMDToCJSModules = false;
    boolean processCommonJSModules = false;
    String commonJSModulePathPrefix = "./";
    public boolean prettyPrint = false;
    public boolean lineBreak = false;
    public boolean preferLineBreakAtEndOfFile = false;
    public boolean printInputDelimiter = false;
    public String inputDelimiter = "// Input %num%";
    boolean preferSingleQuotes;
    boolean trustedStrings;
    String reportPath = null;
    TracerMode tracer;
    private boolean colorizeErrorOutput = false;
    public ErrorFormat errorFormat;
    private ComposeWarningsGuard warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    int summaryDetailLevel = 1;
    int lineLengthThreshold = 500;
    private boolean externExports = false;
    String externExportsPath;
    String nameReferenceReportPath = null;
    String nameReferenceGraphPath = null;
    public String sourceMapOutputPath;
    public SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.SYMBOLS;
    public SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
    public List<SourceMap.LocationMapping> sourceMapLocationMappings = Collections.emptyList();
    String outputCharset;
    boolean looseTypes;
    boolean protectHiddenSideEffects;
    private transient AliasTransformationHandler aliasHandler;
    transient ErrorHandler errorHandler = null;
    static final AliasTransformationHandler NULL_ALIAS_TRANSFORMATION_HANDLER = new NullAliasTransformationHandler();

    public void setAggressiveVarCheck(CheckLevel level) {
        this.aggressiveVarCheck = level;
    }

    public void setTightenTypes(boolean tighten) {
        this.tightenTypes = tighten;
    }

    public void setReportMissingOverride(CheckLevel level) {
        this.reportMissingOverride = level;
    }

    public void setReportUnknownTypes(CheckLevel level) {
        this.reportUnknownTypes = level;
    }

    public void setCheckRequires(CheckLevel level) {
        this.checkRequires = level;
    }

    public void setCheckProvides(CheckLevel level) {
        this.checkProvides = level;
    }

    public void setCheckGlobalNamesLevel(CheckLevel level) {
        this.checkGlobalNamesLevel = level;
    }

    public void setBrokenClosureRequiresLevel(CheckLevel level) {
        this.brokenClosureRequiresLevel = level;
    }

    public void setCheckGlobalThisLevel(CheckLevel level) {
        this.checkGlobalThisLevel = level;
    }

    public void setCheckMissingGetCssNameLevel(CheckLevel level) {
        this.checkMissingGetCssNameLevel = level;
    }

    public void setCheckCaja(boolean check) {
        this.checkCaja = check;
    }

    public void setCheckUnreachableCode(CheckLevel level) {
        this.checkUnreachableCode = level;
    }

    public void setCheckMissingReturn(CheckLevel level) {
        this.checkMissingReturn = level;
    }

    public void setAliasableGlobals(String names) {
        this.aliasableGlobals = names;
    }

    public void setUnaliasableGlobals(String names) {
        this.unaliasableGlobals = names;
    }

    public void setCollapseObjectLiterals(boolean enabled) {
        this.collapseObjectLiterals = enabled;
    }

    public void setSpecializeInitialModule(boolean enabled) {
        this.specializeInitialModule = enabled;
    }

    public void setReplaceMessagesWithChromeI18n(boolean replaceMessagesWithChromeI18n, String tcProjectId) {
        if (replaceMessagesWithChromeI18n && this.messageBundle != null && !(this.messageBundle instanceof EmptyMessageBundle)) {
            throw new RuntimeException("When replacing messages with chrome.i18n.getMessage, a message bundle should not be specified.");
        }
        this.replaceMessagesWithChromeI18n = replaceMessagesWithChromeI18n;
        this.tcProjectId = tcProjectId;
    }

    public void setIgnoreCajaProperties(boolean enabled) {
        this.ignoreCajaProperties = enabled;
    }

    public void setAppNameStr(String appNameStr) {
        this.appNameStr = appNameStr;
    }

    public void setPreferSingleQuotes(boolean enabled) {
        this.preferSingleQuotes = enabled;
    }

    public void setTrustedStrings(boolean yes) {
        this.trustedStrings = yes;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public TracerMode getTracerMode() {
        return this.tracer;
    }

    public void setTracerMode(TracerMode mode) {
        this.tracer = mode;
    }

    public void setNameReferenceReportPath(String filePath) {
        this.nameReferenceReportPath = filePath;
    }

    public void setNameReferenceGraphPath(String filePath) {
        this.nameReferenceGraphPath = filePath;
    }

    public void setProtectHiddenSideEffects(boolean enable) {
        this.protectHiddenSideEffects = enable;
    }

    public CompilerOptions() {
        this.languageIn = LanguageMode.ECMASCRIPT3;
        this.devMode = DevMode.OFF;
        this.aggressiveVarCheck = CheckLevel.OFF;
        this.reportMissingOverride = CheckLevel.OFF;
        this.reportUnknownTypes = CheckLevel.OFF;
        this.checkRequires = CheckLevel.OFF;
        this.checkProvides = CheckLevel.OFF;
        this.checkGlobalNamesLevel = CheckLevel.OFF;
        this.brokenClosureRequiresLevel = CheckLevel.ERROR;
        this.checkGlobalThisLevel = CheckLevel.OFF;
        this.checkUnreachableCode = CheckLevel.OFF;
        this.checkMissingReturn = CheckLevel.OFF;
        this.checkMissingGetCssNameLevel = CheckLevel.OFF;
        this.aliasableStrings = Collections.emptySet();
        this.variableRenaming = VariableRenamingPolicy.OFF;
        this.propertyRenaming = PropertyRenamingPolicy.OFF;
        this.anonymousFunctionNaming = AnonymousFunctionNamingPolicy.OFF;
        this.stripTypes = Collections.emptySet();
        this.stripNameSuffixes = Collections.emptySet();
        this.stripNamePrefixes = Collections.emptySet();
        this.stripTypePrefixes = Collections.emptySet();
        this.defineReplacements = Maps.newHashMap();
        this.tweakProcessing = TweakProcessing.OFF;
        this.tweakReplacements = Maps.newHashMap();
        this.idGenerators = Collections.emptySet();
        this.replaceStringsFunctionDescriptions = Collections.emptyList();
        this.replaceStringsReservedStrings = Collections.emptySet();
        this.propertyInvalidationErrors = Maps.newHashMap();
        this.tracer = TracerMode.OFF;
        this.errorFormat = ErrorFormat.SINGLELINE;
        this.aliasHandler = NULL_ALIAS_TRANSFORMATION_HANDLER;
    }

    public boolean isRemoveUnusedClassProperties() {
        return this.removeUnusedClassProperties;
    }

    public void setRemoveUnusedClassProperties(boolean removeUnusedClassProperties) {
        this.removeUnusedClassProperties = removeUnusedClassProperties;
    }

    public Map<String, Node> getDefineReplacements() {
        return CompilerOptions.getReplacementsHelper(this.defineReplacements);
    }

    public Map<String, Node> getTweakReplacements() {
        return CompilerOptions.getReplacementsHelper(this.tweakReplacements);
    }

    private static Map<String, Node> getReplacementsHelper(Map<String, Object> source) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                map.put(name, NodeUtil.booleanNode((Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                map.put(name, IR.number(((Integer)value).intValue()));
                continue;
            }
            if (value instanceof Double) {
                map.put(name, IR.number((Double)value));
                continue;
            }
            Preconditions.checkState((boolean)(value instanceof String));
            map.put(name, IR.string((String)value));
        }
        return map;
    }

    public void setDefineToBooleanLiteral(String defineName, boolean value) {
        this.defineReplacements.put(defineName, new Boolean(value));
    }

    public void setDefineToStringLiteral(String defineName, String value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setDefineToNumberLiteral(String defineName, int value) {
        this.defineReplacements.put(defineName, new Integer(value));
    }

    public void setDefineToDoubleLiteral(String defineName, double value) {
        this.defineReplacements.put(defineName, new Double(value));
    }

    public void setTweakToBooleanLiteral(String tweakId, boolean value) {
        this.tweakReplacements.put(tweakId, new Boolean(value));
    }

    public void setTweakToStringLiteral(String tweakId, String value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void setTweakToNumberLiteral(String tweakId, int value) {
        this.tweakReplacements.put(tweakId, new Integer(value));
    }

    public void setTweakToDoubleLiteral(String tweakId, double value) {
        this.tweakReplacements.put(tweakId, new Double(value));
    }

    public void skipAllCompilerPasses() {
        this.skipAllPasses = true;
    }

    boolean enables(DiagnosticGroup type) {
        return this.warningsGuard.enables(type);
    }

    boolean disables(DiagnosticGroup type) {
        return this.warningsGuard.disables(type);
    }

    public void setWarningLevel(DiagnosticGroup type, CheckLevel level) {
        this.addWarningsGuard(new DiagnosticGroupWarningsGuard(type, level));
    }

    WarningsGuard getWarningsGuard() {
        return this.warningsGuard;
    }

    public void resetWarningsGuard() {
        this.warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    }

    void useEmergencyFailSafe() {
        this.warningsGuard = this.warningsGuard.makeEmergencyFailSafeGuard();
    }

    public void addWarningsGuard(WarningsGuard guard) {
        this.warningsGuard.addGuard(guard);
    }

    public void setRenamingPolicy(VariableRenamingPolicy newVariablePolicy, PropertyRenamingPolicy newPropertyPolicy) {
        this.variableRenaming = newVariablePolicy;
        this.propertyRenaming = newPropertyPolicy;
    }

    public void setPropertyAffinity(boolean useAffinity) {
        this.propertyAffinity = useAffinity;
    }

    public void setShadowVariables(boolean shadow) {
        this.shadowVariables = shadow;
    }

    public void setCollapsePropertiesOnExternTypes(boolean collapse) {
        this.collapsePropertiesOnExternTypes = collapse;
    }

    public void setProcessObjectPropertyString(boolean process) {
        this.processObjectPropertyString = process;
    }

    public void setReplaceIdGenerators(boolean replaceIdGenerators) {
        this.replaceIdGenerators = replaceIdGenerators;
    }

    public void setIdGenerators(Set<String> idGenerators) {
        this.idGenerators = Sets.newHashSet(idGenerators);
    }

    public void setIdGeneratorsMap(String previousMappings) {
        this.idGeneratorsMapSerialized = previousMappings;
    }

    public void setInlineFunctions(Reach reach) {
        switch (reach) {
            case ALL: {
                this.inlineFunctions = true;
                this.inlineLocalFunctions = true;
                break;
            }
            case LOCAL_ONLY: {
                this.inlineFunctions = false;
                this.inlineLocalFunctions = true;
                break;
            }
            case NONE: {
                this.inlineFunctions = false;
                this.inlineLocalFunctions = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setInlineVariables(Reach reach) {
        switch (reach) {
            case ALL: {
                this.inlineVariables = true;
                this.inlineLocalVariables = true;
                break;
            }
            case LOCAL_ONLY: {
                this.inlineVariables = false;
                this.inlineLocalVariables = true;
                break;
            }
            case NONE: {
                this.inlineVariables = false;
                this.inlineLocalVariables = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setInlineProperties(boolean enable) {
        this.inlineProperties = enable;
    }

    @Deprecated
    public void setRemoveUnusedVariable(Reach reach) {
        this.setRemoveUnusedVariables(reach);
    }

    public void setRemoveUnusedVariables(Reach reach) {
        switch (reach) {
            case ALL: {
                this.removeUnusedVars = true;
                this.removeUnusedLocalVars = true;
                break;
            }
            case LOCAL_ONLY: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = true;
                break;
            }
            case NONE: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setReplaceStringsConfiguration(String placeholderToken, List<String> functionDescriptors) {
        this.replaceStringsPlaceholderToken = placeholderToken;
        this.replaceStringsFunctionDescriptions = Lists.newArrayList(functionDescriptors);
    }

    @Deprecated
    public void setRewriteNewDateGoogNow(boolean rewrite) {
    }

    public void setRemoveAbstractMethods(boolean remove) {
        this.removeAbstractMethods = remove;
    }

    public void setRemoveClosureAsserts(boolean remove) {
        this.removeClosureAsserts = remove;
    }

    public void setNameAnonymousFunctionsOnly(boolean value) {
        this.nameAnonymousFunctionsOnly = value;
    }

    public void setColorizeErrorOutput(boolean colorizeErrorOutput) {
        this.colorizeErrorOutput = colorizeErrorOutput;
    }

    public boolean shouldColorizeErrorOutput() {
        return this.colorizeErrorOutput;
    }

    public void setChainCalls(boolean value) {
        this.chainCalls = value;
    }

    public void setAcceptConstKeyword(boolean value) {
        this.acceptConstKeyword = value;
    }

    public void enableRuntimeTypeCheck(String logFunction) {
        this.runtimeTypeCheck = true;
        this.runtimeTypeCheckLogFunction = logFunction;
    }

    public void disableRuntimeTypeCheck() {
        this.runtimeTypeCheck = false;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void setCodingConvention(CodingConvention codingConvention) {
        this.codingConvention = codingConvention;
    }

    public CodingConvention getCodingConvention() {
        return this.codingConvention;
    }

    public void setDependencyOptions(DependencyOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.dependencyOptions = options;
    }

    public void setManageClosureDependencies(boolean newVal) {
        this.dependencyOptions.setDependencySorting(newVal || this.dependencyOptions.shouldSortDependencies());
        this.dependencyOptions.setDependencyPruning(newVal || this.dependencyOptions.shouldPruneDependencies());
        this.dependencyOptions.setMoocherDropping(false);
        this.manageClosureDependencies = newVal;
    }

    public void setManageClosureDependencies(List<String> entryPoints) {
        Preconditions.checkNotNull(entryPoints);
        this.setManageClosureDependencies(true);
        this.dependencyOptions.setEntryPoints(entryPoints);
    }

    public void setSummaryDetailLevel(int summaryDetailLevel) {
        this.summaryDetailLevel = summaryDetailLevel;
    }

    @Deprecated
    public void enableExternExports(boolean enabled) {
        this.externExports = enabled;
    }

    public void setExtraAnnotationNames(Set<String> extraAnnotationNames) {
        this.extraAnnotationNames = Sets.newHashSet(extraAnnotationNames);
    }

    public boolean isExternExportsEnabled() {
        return this.externExports;
    }

    public void setOutputCharset(String charsetName) {
        this.outputCharset = charsetName;
    }

    Charset getOutputCharset() {
        return this.outputCharset == null ? null : Charset.forName(this.outputCharset);
    }

    public void setTweakProcessing(TweakProcessing tweakProcessing) {
        this.tweakProcessing = tweakProcessing;
    }

    public TweakProcessing getTweakProcessing() {
        return this.tweakProcessing;
    }

    public void setLanguageIn(LanguageMode languageIn) {
        this.languageIn = languageIn;
        this.languageOut = languageIn;
    }

    public LanguageMode getLanguageIn() {
        return this.languageIn;
    }

    public LanguageMode getLanguageOut() {
        return this.languageOut;
    }

    public void setLooseTypes(boolean looseTypes) {
        this.looseTypes = looseTypes;
    }

    public Object clone() throws CloneNotSupportedException {
        CompilerOptions clone = (CompilerOptions)super.clone();
        return clone;
    }

    public void setAliasTransformationHandler(AliasTransformationHandler changes) {
        this.aliasHandler = changes;
    }

    public AliasTransformationHandler getAliasTransformationHandler() {
        return this.aliasHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setInferTypes(boolean enable) {
        this.inferTypes = enable;
    }

    public boolean getInferTypes() {
        return this.inferTypes;
    }

    public boolean assumeStrictThis() {
        return this.assumeStrictThis;
    }

    public void setAssumeStrictThis(boolean enable) {
        this.assumeStrictThis = enable;
    }

    public void setPropertyInvalidationErrors(Map<String, CheckLevel> propertyInvalidationErrors) {
        this.propertyInvalidationErrors = Maps.newHashMap(propertyInvalidationErrors);
    }

    public void setLanguageOut(LanguageMode languageOut) {
        this.languageOut = languageOut;
    }

    public void setIdeMode(boolean ideMode) {
        this.ideMode = ideMode;
    }

    public void setSaveDataStructures(boolean save) {
        this.saveDataStructures = save;
    }

    public void setSkipAllPasses(boolean skipAllPasses) {
        this.skipAllPasses = skipAllPasses;
    }

    public void setDevMode(DevMode devMode) {
        this.devMode = devMode;
    }

    public void setMessageBundle(MessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public void setCheckSymbols(boolean checkSymbols) {
        this.checkSymbols = checkSymbols;
    }

    public void setCheckSuspiciousCode(boolean checkSuspiciousCode) {
        this.checkSuspiciousCode = checkSuspiciousCode;
    }

    public void setCheckControlStructures(boolean checkControlStructures) {
        this.checkControlStructures = checkControlStructures;
    }

    public void setCheckTypes(boolean checkTypes) {
        this.checkTypes = checkTypes;
    }

    public void setCheckMissingGetCssNameBlacklist(String blackList) {
        this.checkMissingGetCssNameBlacklist = blackList;
    }

    public void setFoldConstants(boolean foldConstants) {
        this.foldConstants = foldConstants;
    }

    public void setDeadAssignmentElimination(boolean deadAssignmentElimination) {
        this.deadAssignmentElimination = deadAssignmentElimination;
    }

    public void setInlineConstantVars(boolean inlineConstantVars) {
        this.inlineConstantVars = inlineConstantVars;
    }

    public void setInlineFunctions(boolean inlineFunctions) {
        this.inlineFunctions = inlineFunctions;
    }

    public void setInlineLocalFunctions(boolean inlineLocalFunctions) {
        this.inlineLocalFunctions = inlineLocalFunctions;
    }

    public void setCrossModuleCodeMotion(boolean crossModuleCodeMotion) {
        this.crossModuleCodeMotion = crossModuleCodeMotion;
    }

    public void setCoalesceVariableNames(boolean coalesceVariableNames) {
        this.coalesceVariableNames = coalesceVariableNames;
    }

    public void setCrossModuleMethodMotion(boolean crossModuleMethodMotion) {
        this.crossModuleMethodMotion = crossModuleMethodMotion;
    }

    public void setInlineGetters(boolean inlineGetters) {
        this.inlineGetters = inlineGetters;
    }

    public void setInlineVariables(boolean inlineVariables) {
        this.inlineVariables = inlineVariables;
    }

    public void setInlineLocalVariables(boolean inlineLocalVariables) {
        this.inlineLocalVariables = inlineLocalVariables;
    }

    public void setFlowSensitiveInlineVariables(boolean enabled) {
        this.flowSensitiveInlineVariables = enabled;
    }

    public void setSmartNameRemoval(boolean smartNameRemoval) {
        this.smartNameRemoval = smartNameRemoval;
    }

    public void setRemoveDeadCode(boolean removeDeadCode) {
        this.removeDeadCode = removeDeadCode;
    }

    public void setExtractPrototypeMemberDeclarations(boolean enabled) {
        this.extractPrototypeMemberDeclarations = enabled;
    }

    public void setRemoveUnusedPrototypeProperties(boolean enabled) {
        this.removeUnusedPrototypeProperties = enabled;
    }

    public void setRemoveUnusedPrototypePropertiesInExterns(boolean enabled) {
        this.removeUnusedPrototypePropertiesInExterns = enabled;
    }

    public void setRemoveUnusedVars(boolean removeUnusedVars) {
        this.removeUnusedVars = removeUnusedVars;
    }

    public void setRemoveUnusedLocalVars(boolean removeUnusedLocalVars) {
        this.removeUnusedLocalVars = removeUnusedLocalVars;
    }

    public void setAliasExternals(boolean aliasExternals) {
        this.aliasExternals = aliasExternals;
    }

    public void setCollapseVariableDeclarations(boolean enabled) {
        this.collapseVariableDeclarations = enabled;
    }

    public void setGroupVariableDeclarations(boolean enabled) {
        this.groupVariableDeclarations = enabled;
    }

    public void setCollapseAnonymousFunctions(boolean enabled) {
        this.collapseAnonymousFunctions = enabled;
    }

    public void setAliasableStrings(Set<String> aliasableStrings) {
        this.aliasableStrings = aliasableStrings;
    }

    public void setAliasStringsBlacklist(String aliasStringsBlacklist) {
        this.aliasStringsBlacklist = aliasStringsBlacklist;
    }

    public void setAliasAllStrings(boolean aliasAllStrings) {
        this.aliasAllStrings = aliasAllStrings;
    }

    public void setOutputJsStringUsage(boolean outputJsStringUsage) {
        this.outputJsStringUsage = outputJsStringUsage;
    }

    public void setConvertToDottedProperties(boolean convertToDottedProperties) {
        this.convertToDottedProperties = convertToDottedProperties;
    }

    public void setRewriteFunctionExpressions(boolean rewriteFunctionExpressions) {
        this.rewriteFunctionExpressions = rewriteFunctionExpressions;
    }

    public void setOptimizeParameters(boolean optimizeParameters) {
        this.optimizeParameters = optimizeParameters;
    }

    public void setOptimizeReturns(boolean optimizeReturns) {
        this.optimizeReturns = optimizeReturns;
    }

    public void setOptimizeCalls(boolean optimizeCalls) {
        this.optimizeCalls = optimizeCalls;
    }

    public void setOptimizeArgumentsArray(boolean optimizeArgumentsArray) {
        this.optimizeArgumentsArray = optimizeArgumentsArray;
    }

    public void setVariableRenaming(VariableRenamingPolicy variableRenaming) {
        this.variableRenaming = variableRenaming;
    }

    public void setPropertyRenaming(PropertyRenamingPolicy propertyRenaming) {
        this.propertyRenaming = propertyRenaming;
    }

    public void setLabelRenaming(boolean labelRenaming) {
        this.labelRenaming = labelRenaming;
    }

    public void setReserveRawExports(boolean reserveRawExports) {
        this.reserveRawExports = reserveRawExports;
    }

    public void setGeneratePseudoNames(boolean generatePseudoNames) {
        this.generatePseudoNames = generatePseudoNames;
    }

    public void setRenamePrefix(String renamePrefix) {
        this.renamePrefix = renamePrefix;
    }

    public void setRenamePrefixNamespace(String renamePrefixNamespace) {
        this.renamePrefixNamespace = renamePrefixNamespace;
    }

    public void setAliasKeywords(boolean aliasKeywords) {
        this.aliasKeywords = aliasKeywords;
    }

    public void setCollapseProperties(boolean collapseProperties) {
        this.collapseProperties = collapseProperties;
    }

    public void setDevirtualizePrototypeMethods(boolean devirtualizePrototypeMethods) {
        this.devirtualizePrototypeMethods = devirtualizePrototypeMethods;
    }

    public void setComputeFunctionSideEffects(boolean computeFunctionSideEffects) {
        this.computeFunctionSideEffects = computeFunctionSideEffects;
    }

    public void setDebugFunctionSideEffectsPath(String debugFunctionSideEffectsPath) {
        this.debugFunctionSideEffectsPath = debugFunctionSideEffectsPath;
    }

    public void setDisambiguateProperties(boolean disambiguateProperties) {
        this.disambiguateProperties = disambiguateProperties;
    }

    public void setAmbiguateProperties(boolean ambiguateProperties) {
        this.ambiguateProperties = ambiguateProperties;
    }

    public void setAnonymousFunctionNaming(AnonymousFunctionNamingPolicy anonymousFunctionNaming) {
        this.anonymousFunctionNaming = anonymousFunctionNaming;
    }

    public void setInputAnonymousFunctionNamingMap(VariableMap inputMap) {
        this.inputAnonymousFunctionNamingMap = inputMap;
    }

    @Deprecated
    public void setInputVariableMapSerialized(byte[] inputVariableMapSerialized) throws ParseException {
        this.inputVariableMap = VariableMap.fromBytes(inputVariableMapSerialized);
    }

    public void setInputVariableMap(VariableMap inputVariableMap) {
        this.inputVariableMap = inputVariableMap;
    }

    @Deprecated
    public void setInputPropertyMapSerialized(byte[] inputPropertyMapSerialized) throws ParseException {
        this.inputPropertyMap = VariableMap.fromBytes(inputPropertyMapSerialized);
    }

    public void setInputPropertyMap(VariableMap inputPropertyMap) {
        this.inputPropertyMap = inputPropertyMap;
    }

    public void setExportTestFunctions(boolean exportTestFunctions) {
        this.exportTestFunctions = exportTestFunctions;
    }

    public void setRuntimeTypeCheck(boolean runtimeTypeCheck) {
        this.runtimeTypeCheck = runtimeTypeCheck;
    }

    public void setRuntimeTypeCheckLogFunction(String runtimeTypeCheckLogFunction) {
        this.runtimeTypeCheckLogFunction = runtimeTypeCheckLogFunction;
    }

    public void setSyntheticBlockStartMarker(String syntheticBlockStartMarker) {
        this.syntheticBlockStartMarker = syntheticBlockStartMarker;
    }

    public void setSyntheticBlockEndMarker(String syntheticBlockEndMarker) {
        this.syntheticBlockEndMarker = syntheticBlockEndMarker;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setMarkAsCompiled(boolean markAsCompiled) {
        this.markAsCompiled = markAsCompiled;
    }

    public void setRemoveTryCatchFinally(boolean removeTryCatchFinally) {
        this.removeTryCatchFinally = removeTryCatchFinally;
    }

    public void setClosurePass(boolean closurePass) {
        this.closurePass = closurePass;
    }

    public void setGatherCssNames(boolean gatherCssNames) {
        this.gatherCssNames = gatherCssNames;
    }

    public void setStripTypes(Set<String> stripTypes) {
        this.stripTypes = stripTypes;
    }

    public void setStripNameSuffixes(Set<String> stripNameSuffixes) {
        this.stripNameSuffixes = stripNameSuffixes;
    }

    public void setStripNamePrefixes(Set<String> stripNamePrefixes) {
        this.stripNamePrefixes = stripNamePrefixes;
    }

    public void setStripTypePrefixes(Set<String> stripTypePrefixes) {
        this.stripTypePrefixes = stripTypePrefixes;
    }

    public void setCustomPasses(Multimap<CustomPassExecutionTime, CompilerPass> customPasses) {
        this.customPasses = customPasses;
    }

    public void setMarkNoSideEffectCalls(boolean markNoSideEffectCalls) {
        this.markNoSideEffectCalls = markNoSideEffectCalls;
    }

    public void setDefineReplacements(Map<String, Object> defineReplacements) {
        this.defineReplacements = defineReplacements;
    }

    public void setTweakReplacements(Map<String, Object> tweakReplacements) {
        this.tweakReplacements = tweakReplacements;
    }

    public void setMoveFunctionDeclarations(boolean moveFunctionDeclarations) {
        this.moveFunctionDeclarations = moveFunctionDeclarations;
    }

    public void setInstrumentationTemplate(String instrumentationTemplate) {
        this.instrumentationTemplate = instrumentationTemplate;
    }

    public void setRecordFunctionInformation(boolean recordFunctionInformation) {
        this.recordFunctionInformation = recordFunctionInformation;
    }

    public void setCssRenamingMap(CssRenamingMap cssRenamingMap) {
        this.cssRenamingMap = cssRenamingMap;
    }

    public void setCssRenamingWhitelist(Set<String> whitelist) {
        this.cssRenamingWhitelist = whitelist;
    }

    public void setReplaceStringsFunctionDescriptions(List<String> replaceStringsFunctionDescriptions) {
        this.replaceStringsFunctionDescriptions = replaceStringsFunctionDescriptions;
    }

    public void setReplaceStringsPlaceholderToken(String replaceStringsPlaceholderToken) {
        this.replaceStringsPlaceholderToken = replaceStringsPlaceholderToken;
    }

    public void setReplaceStringsReservedStrings(Set<String> replaceStringsReservedStrings) {
        this.replaceStringsReservedStrings = replaceStringsReservedStrings;
    }

    public void setReplaceStringsInputMap(VariableMap serializedMap) {
        this.replaceStringsInputMap = serializedMap;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setLineBreak(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public void setPreferLineBreakAtEndOfFile(boolean lineBreakAtEnd) {
        this.preferLineBreakAtEndOfFile = lineBreakAtEnd;
    }

    public void setPrintInputDelimiter(boolean printInputDelimiter) {
        this.printInputDelimiter = printInputDelimiter;
    }

    public void setInputDelimiter(String inputDelimiter) {
        this.inputDelimiter = inputDelimiter;
    }

    public void setTracer(TracerMode tracer) {
        this.tracer = tracer;
    }

    public void setErrorFormat(ErrorFormat errorFormat) {
        this.errorFormat = errorFormat;
    }

    public void setWarningsGuard(ComposeWarningsGuard warningsGuard) {
        this.warningsGuard = warningsGuard;
    }

    public void setLineLengthThreshold(int lineLengthThreshold) {
        this.lineLengthThreshold = lineLengthThreshold;
    }

    public void setExternExports(boolean externExports) {
        this.externExports = externExports;
    }

    public void setExternExportsPath(String externExportsPath) {
        this.externExportsPath = externExportsPath;
    }

    public void setSourceMapOutputPath(String sourceMapOutputPath) {
        this.sourceMapOutputPath = sourceMapOutputPath;
    }

    public void setSourceMapDetailLevel(SourceMap.DetailLevel sourceMapDetailLevel) {
        this.sourceMapDetailLevel = sourceMapDetailLevel;
    }

    public void setSourceMapFormat(SourceMap.Format sourceMapFormat) {
        this.sourceMapFormat = sourceMapFormat;
    }

    public void setSourceMapLocationMappings(List<SourceMap.LocationMapping> sourceMapLocationMappings) {
        this.sourceMapLocationMappings = sourceMapLocationMappings;
    }

    public void setTransformAMDToCJSModules(boolean transformAMDToCJSModules) {
        this.transformAMDToCJSModules = transformAMDToCJSModules;
    }

    public void setProcessCommonJSModules(boolean processCommonJSModules) {
        this.processCommonJSModules = processCommonJSModules;
    }

    public void setCommonJSModulePathPrefix(String commonJSModulePathPrefix) {
        this.commonJSModulePathPrefix = commonJSModulePathPrefix;
    }

    private static class NullAliasTransformationHandler
    implements AliasTransformationHandler,
    Serializable {
        private static final long serialVersionUID = 0L;
        private static final AliasTransformation NULL_ALIAS_TRANSFORMATION = new NullAliasTransformation();

        private NullAliasTransformationHandler() {
        }

        @Override
        public AliasTransformation logAliasTransformation(String sourceFile, SourcePosition<AliasTransformation> position) {
            position.setItem(NULL_ALIAS_TRANSFORMATION);
            return NULL_ALIAS_TRANSFORMATION;
        }

        private static class NullAliasTransformation
        implements AliasTransformation,
        Serializable {
            private static final long serialVersionUID = 0L;

            private NullAliasTransformation() {
            }

            @Override
            public void addAlias(String alias, String definition) {
            }
        }
    }

    public static interface AliasTransformation {
        public void addAlias(String var1, String var2);
    }

    public static interface AliasTransformationHandler {
        public AliasTransformation logAliasTransformation(String var1, SourcePosition<AliasTransformation> var2);
    }

    public static enum TweakProcessing {
        OFF,
        CHECK,
        STRIP;


        public boolean isOn() {
            return this != OFF;
        }

        public boolean shouldStrip() {
            return this == STRIP;
        }
    }

    public static enum TracerMode {
        ALL,
        RAW_SIZE,
        TIMING_ONLY,
        OFF;


        boolean isOn() {
            return this != OFF;
        }
    }

    static enum DevMode {
        OFF,
        START,
        START_AND_END,
        EVERY_PASS;

    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT;


        public static LanguageMode fromString(String value) {
            if (value.equals("ECMASCRIPT5_STRICT") || value.equals("ES5_STRICT")) {
                return ECMASCRIPT5_STRICT;
            }
            if (value.equals("ECMASCRIPT5") || value.equals("ES5")) {
                return ECMASCRIPT5;
            }
            if (value.equals("ECMASCRIPT3") || value.equals("ES3")) {
                return ECMASCRIPT3;
            }
            return null;
        }
    }

    public static enum Reach {
        ALL,
        LOCAL_ONLY,
        NONE;

    }
}

