/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.debugging.sourcemap.Base64;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class ReplaceIdGenerators
implements CompilerPass {
    static final DiagnosticType NON_GLOBAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_NON_GLOBAL_ID_GENERATOR_CALL", "Id generator call must be in the global scope");
    static final DiagnosticType CONDITIONAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_CONDITIONAL_ID_GENERATOR_CALL", "Id generator call must be unconditional");
    static final DiagnosticType CONFLICTING_GENERATOR_TYPE = DiagnosticType.error("JSC_CONFLICTING_ID_GENERATOR_TYPE", "Id generator can only be one of consistent, inconsistent, or stable.");
    static final DiagnosticType INVALID_GENERATOR_ID_MAPPING = DiagnosticType.error("JSC_INVALID_GENERATOR_ID_MAPPING", "Invalid generator id mapping. {0}");
    private final AbstractCompiler compiler;
    private final Map<String, NameSupplier> nameGenerators;
    private final Map<String, Map<String, String>> consistNameMap;
    private final Map<String, Map<String, String>> idGeneratorMaps;
    private final Map<String, BiMap<String, String>> previousMap;
    private final boolean generatePseudoNames;

    public ReplaceIdGenerators(AbstractCompiler compiler, Set<String> idGens, boolean generatePseudoNames, String previousMapSerialized) {
        this.compiler = compiler;
        this.generatePseudoNames = generatePseudoNames;
        this.nameGenerators = Maps.newLinkedHashMap();
        this.idGeneratorMaps = Maps.newLinkedHashMap();
        this.consistNameMap = Maps.newLinkedHashMap();
        Map<String, BiMap<String, String>> previousMap = this.parsePreviousResults(previousMapSerialized);
        this.previousMap = previousMap;
        if (idGens != null) {
            for (String gen : idGens) {
                this.nameGenerators.put(gen, this.createNameSupplier(RenameStrategy.INCONSISTENT, previousMap.get(gen)));
                this.idGeneratorMaps.put(gen, Maps.newLinkedHashMap());
            }
        }
    }

    private NameSupplier createNameSupplier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
        ImmutableBiMap immutableBiMap = previousMappings = previousMappings != null ? previousMappings : ImmutableBiMap.of();
        if (renameStrategy == RenameStrategy.STABLE) {
            return new StableNameSupplier();
        }
        if (this.generatePseudoNames) {
            return new PseudoNameSuppier(renameStrategy);
        }
        return new ObfuscatedNameSuppier(renameStrategy, (BiMap<String, String>)previousMappings);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherGenerators());
        if (!this.nameGenerators.isEmpty()) {
            NodeTraversal.traverse(this.compiler, root, new ReplaceGenerators());
        }
    }

    public String getSerializedIdMappings() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> replacements : this.idGeneratorMaps.entrySet()) {
            if (replacements.getValue().isEmpty()) continue;
            sb.append("[");
            sb.append(replacements.getKey());
            sb.append("]\n\n");
            for (Map.Entry<String, String> replacement : replacements.getValue().entrySet()) {
                sb.append(replacement.getKey());
                sb.append(':');
                sb.append(replacement.getValue());
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private Map<String, BiMap<String, String>> parsePreviousResults(String serializedMap) {
        if (serializedMap == null || serializedMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMap();
        BufferedReader reader = new BufferedReader(new StringReader(serializedMap));
        BiMap currentSectionMap = null;
        int lineIndex = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                ++lineIndex;
                if (line.isEmpty()) continue;
                if (line.charAt(0) == '[') {
                    String currentSection = line.substring(1, line.length() - 1);
                    currentSectionMap = (BiMap)resultMap.get(currentSection);
                    if (currentSectionMap == null) {
                        currentSectionMap = HashBiMap.create();
                        resultMap.put(currentSection, currentSectionMap);
                        continue;
                    }
                    this.reportInvalidLine(line, lineIndex);
                    return Collections.emptyMap();
                }
                int split = line.indexOf(58);
                if (split != -1) {
                    String name = line.substring(0, split);
                    String location = line.substring(split + 1, line.length());
                    currentSectionMap.put((Object)name, (Object)location);
                    continue;
                }
                this.reportInvalidLine(line, lineIndex);
                return Collections.emptyMap();
            }
        }
        catch (IOException e) {
            JSError.make(INVALID_GENERATOR_ID_MAPPING, e.getMessage());
        }
        return resultMap;
    }

    private void reportInvalidLine(String line, int lineIndex) {
        JSError.make(INVALID_GENERATOR_ID_MAPPING, "line(" + line + "): " + lineIndex);
    }

    String getIdForGeneratorNode(boolean consistent, Node n) {
        Preconditions.checkState((boolean)n.isString());
        if (consistent) {
            return n.getString();
        }
        return n.getSourceFileName() + ':' + n.getLineno() + ":" + n.getCharno();
    }

    private class ReplaceGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private ReplaceGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node id;
            if (!n.isCall()) {
                return;
            }
            String callName = n.getFirstChild().getQualifiedName();
            NameSupplier nameGenerator = (NameSupplier)ReplaceIdGenerators.this.nameGenerators.get(callName);
            if (nameGenerator == null) {
                return;
            }
            if (!t.inGlobalScope() && nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, NON_GLOBAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            if (nameGenerator.getRenameStrategy() == RenameStrategy.INCONSISTENT) {
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isControlStructure(ancestor)) continue;
                    ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONDITIONAL_ID_GENERATOR_CALL, new String[0]));
                    return;
                }
            }
            if (!(id = n.getFirstChild().getNext()).isString()) {
                return;
            }
            Map idGeneratorMap = (Map)ReplaceIdGenerators.this.idGeneratorMaps.get(callName);
            String rename = null;
            String name = id.getString();
            String instanceId = ReplaceIdGenerators.this.getIdForGeneratorNode(nameGenerator.getRenameStrategy() == RenameStrategy.CONSISTENT, id);
            if (nameGenerator.getRenameStrategy() == RenameStrategy.CONSISTENT) {
                Map entry = (Map)ReplaceIdGenerators.this.consistNameMap.get(callName);
                rename = (String)entry.get(instanceId);
                if (rename == null) {
                    rename = nameGenerator.getName(instanceId, name);
                    entry.put(instanceId, rename);
                }
            } else {
                rename = nameGenerator.getName(instanceId, name);
            }
            parent.replaceChild(n, IR.string(rename));
            idGeneratorMap.put(rename, instanceId);
            ReplaceIdGenerators.this.compiler.reportCodeChange();
        }
    }

    private class GatherGenerators
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherGenerators() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo doc = n.getJSDocInfo();
            if (doc == null) {
                return;
            }
            int numGeneratorAnnotations = (doc.isConsistentIdGenerator() ? 1 : 0) + (doc.isIdGenerator() ? 1 : 0) + (doc.isStableIdGenerator() ? 1 : 0);
            if (numGeneratorAnnotations == 0) {
                return;
            }
            if (numGeneratorAnnotations > 1) {
                ReplaceIdGenerators.this.compiler.report(t.makeError(n, CONFLICTING_GENERATOR_TYPE, new String[0]));
            }
            String name = null;
            if (n.isAssign()) {
                name = n.getFirstChild().getQualifiedName();
            } else if (n.isVar()) {
                name = n.getFirstChild().getString();
            } else if (n.isFunction() && (name = n.getFirstChild().getString()).isEmpty()) {
                return;
            }
            if (doc.isConsistentIdGenerator()) {
                ReplaceIdGenerators.this.consistNameMap.put(name, Maps.newLinkedHashMap());
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.CONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else if (doc.isStableIdGenerator()) {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.STABLE, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            } else {
                ReplaceIdGenerators.this.nameGenerators.put(name, ReplaceIdGenerators.this.createNameSupplier(RenameStrategy.INCONSISTENT, (BiMap<String, String>)((BiMap)ReplaceIdGenerators.this.previousMap.get(name))));
            }
            ReplaceIdGenerators.this.idGeneratorMaps.put(name, Maps.newLinkedHashMap());
        }
    }

    private static class StableNameSupplier
    implements NameSupplier {
        private StableNameSupplier() {
        }

        @Override
        public String getName(String id, String name) {
            return Base64.base64EncodeInt(name.hashCode());
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return RenameStrategy.STABLE;
        }
    }

    private static class PseudoNameSuppier
    implements NameSupplier {
        private int counter = 0;
        private RenameStrategy renameStrategy;

        public PseudoNameSuppier(RenameStrategy renameStrategy) {
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            if (this.renameStrategy == RenameStrategy.INCONSISTENT) {
                return name + "$" + this.counter++;
            }
            return name + "$0";
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static class ObfuscatedNameSuppier
    implements NameSupplier {
        private final NameGenerator generator;
        private final Map<String, String> previousMappings;
        private RenameStrategy renameStrategy;

        public ObfuscatedNameSuppier(RenameStrategy renameStrategy, BiMap<String, String> previousMappings) {
            this.previousMappings = previousMappings.inverse();
            this.generator = new NameGenerator(previousMappings.keySet(), "", null);
            this.renameStrategy = renameStrategy;
        }

        @Override
        public String getName(String id, String name) {
            String newName = this.previousMappings.get(id);
            if (newName == null) {
                newName = this.generator.generateNextName();
            }
            return newName;
        }

        @Override
        public RenameStrategy getRenameStrategy() {
            return this.renameStrategy;
        }
    }

    private static interface NameSupplier {
        public String getName(String var1, String var2);

        public RenameStrategy getRenameStrategy();
    }

    private static enum RenameStrategy {
        CONSISTENT,
        INCONSISTENT,
        STABLE;

    }
}

