/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.changelog;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.changelog.AbstractChangeLogEntry;
import com.phloc.commons.changelog.ChangeLogEntry;
import com.phloc.commons.changelog.ChangeLogRelease;
import com.phloc.commons.changelog.EChangeLogCategory;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.version.Version;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ChangeLog {
    private final String m_sOriginalVersion;
    private final Version m_aVersion;
    private final String m_sComponent;
    private final List<AbstractChangeLogEntry> m_aEntries = new ArrayList<AbstractChangeLogEntry>();

    @Deprecated
    public ChangeLog(@Nonnull Version version, @Nonnull @Nonempty String string) {
        this(version.getAsString(), string);
    }

    public ChangeLog(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("version");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("component");
        }
        this.m_sOriginalVersion = string;
        this.m_aVersion = new Version(string);
        this.m_sComponent = string2;
    }

    @Nonnull
    @Nonempty
    public String getOriginalVersion() {
        return this.m_sOriginalVersion;
    }

    @Nonnull
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Nonnull
    @Nonempty
    public String getComponent() {
        return this.m_sComponent;
    }

    public void addEntry(@Nonnull ChangeLogEntry changeLogEntry) {
        if (changeLogEntry == null) {
            throw new NullPointerException("entry");
        }
        this.m_aEntries.add(changeLogEntry);
    }

    public void addEntry(@Nonnegative int n, @Nonnull ChangeLogEntry changeLogEntry) {
        if (changeLogEntry == null) {
            throw new NullPointerException("entry");
        }
        this.m_aEntries.add(n, changeLogEntry);
    }

    @Nonnull
    @ReturnsImmutableObject
    public List<AbstractChangeLogEntry> getAllBaseEntries() {
        return ContainerHelper.makeUnmodifiable(this.m_aEntries);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogEntry> getAllEntries() {
        ArrayList<ChangeLogEntry> arrayList = new ArrayList<ChangeLogEntry>();
        for (AbstractChangeLogEntry abstractChangeLogEntry : this.m_aEntries) {
            if (!(abstractChangeLogEntry instanceof ChangeLogEntry)) continue;
            arrayList.add((ChangeLogEntry)abstractChangeLogEntry);
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogEntry> getAllEntriesOfCategory(@Nonnull EChangeLogCategory eChangeLogCategory) {
        if (eChangeLogCategory == null) {
            throw new NullPointerException("category");
        }
        ArrayList<ChangeLogEntry> arrayList = new ArrayList<ChangeLogEntry>();
        for (AbstractChangeLogEntry abstractChangeLogEntry : this.m_aEntries) {
            ChangeLogEntry changeLogEntry;
            if (!(abstractChangeLogEntry instanceof ChangeLogEntry) || !(changeLogEntry = (ChangeLogEntry)abstractChangeLogEntry).getCategory().equals(eChangeLogCategory)) continue;
            arrayList.add(changeLogEntry);
        }
        return arrayList;
    }

    public void addRelease(@Nonnull ChangeLogRelease changeLogRelease) {
        if (changeLogRelease == null) {
            throw new NullPointerException("release");
        }
        this.m_aEntries.add(changeLogRelease);
    }

    public void addRelease(@Nonnegative int n, @Nonnull ChangeLogRelease changeLogRelease) {
        if (changeLogRelease == null) {
            throw new NullPointerException("release");
        }
        this.m_aEntries.add(n, changeLogRelease);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogRelease> getAllReleases() {
        ArrayList<ChangeLogRelease> arrayList = new ArrayList<ChangeLogRelease>();
        for (AbstractChangeLogEntry abstractChangeLogEntry : this.m_aEntries) {
            if (!(abstractChangeLogEntry instanceof ChangeLogRelease)) continue;
            arrayList.add((ChangeLogRelease)abstractChangeLogEntry);
        }
        return arrayList;
    }

    @Nullable
    public ChangeLogRelease getLatestRelease() {
        ChangeLogRelease changeLogRelease = null;
        for (AbstractChangeLogEntry abstractChangeLogEntry : this.m_aEntries) {
            if (!(abstractChangeLogEntry instanceof ChangeLogRelease)) continue;
            ChangeLogRelease changeLogRelease2 = (ChangeLogRelease)abstractChangeLogEntry;
            if (changeLogRelease != null && changeLogRelease2.getDate().getTime() <= changeLogRelease.getDate().getTime()) continue;
            changeLogRelease = changeLogRelease2;
        }
        return changeLogRelease;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ChangeLog)) {
            return false;
        }
        ChangeLog changeLog = (ChangeLog)object;
        return this.m_sOriginalVersion.equals(changeLog.m_sOriginalVersion) && this.m_aVersion.equals(changeLog.m_aVersion) && this.m_sComponent.equals(changeLog.m_sComponent) && ((Object)this.m_aEntries).equals(changeLog.m_aEntries);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sOriginalVersion).append(this.m_aVersion).append(this.m_sComponent).append(this.m_aEntries)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("originalVersion", this.m_sOriginalVersion).append("version", this.m_aVersion).append("component", this.m_sComponent).append("entries", this.m_aEntries).toString();
    }
}

