/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.charset;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.string.StringHelper;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.SortedMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CharsetManager {
    private static final SortedMap<String, Charset> s_aAllCharsets = Charset.availableCharsets();
    private static final CharsetManager s_aInstance = new CharsetManager();

    private CharsetManager() {
    }

    @Nonnull
    public static Charset getCharsetFromName(@Nonnull String string) {
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new IllegalArgumentException("Charset '" + string + "' unsupported in Java", illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new IllegalArgumentException("Charset '" + string + "' unsupported on this platform", unsupportedCharsetException);
        }
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedMap<String, Charset> getAllCharsets() {
        return s_aAllCharsets;
    }

    @Nonnull
    public static byte[] getAsBytes(@Nonnull String string, @Nonnull Charset charset) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (!charset.canEncode()) {
            throw new IllegalArgumentException("Cannot encode to " + charset);
        }
        return string.getBytes(charset);
    }

    @Nonnull
    @Deprecated
    public static byte[] getAsBytes(@Nonnull String string, @Nonnull @Nonempty String string2) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("empty charset");
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Failed to get string bytes in charset '" + string2 + "'", unsupportedEncodingException);
        }
    }

    @Nullable
    @Deprecated
    public static String getAsStringInOtherCharset(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        if (string2 == null) {
            throw new NullPointerException("currentCharset");
        }
        if (string3 == null) {
            throw new NullPointerException("newCharset");
        }
        if (string == null || string2.equals(string3)) {
            return string;
        }
        return CharsetManager.getAsString(CharsetManager.getAsBytes(string, string2), string3);
    }

    @Nullable
    public static String getAsStringInOtherCharset(@Nullable String string, @Nonnull Charset charset, @Nonnull Charset charset2) {
        if (charset == null) {
            throw new NullPointerException("currentCharset");
        }
        if (charset2 == null) {
            throw new NullPointerException("newCharset");
        }
        if (string == null || charset.equals(charset2)) {
            return string;
        }
        return CharsetManager.getAsString(CharsetManager.getAsBytes(string, charset), charset2);
    }

    @Nonnull
    @Deprecated
    public static String getAsString(@Nonnull byte[] byArray, @Nonnull String string) {
        return CharsetManager.getAsString(byArray, 0, byArray.length, string);
    }

    @Nonnull
    @Deprecated
    public static String getAsString(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unknown charset '" + string + "'", unsupportedEncodingException);
        }
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        return CharsetManager.getAsString(byArray, 0, byArray.length, charset);
    }

    @Nonnull
    public static String getAsString(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        if (byArray == null) {
            throw new NullPointerException("buffer");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return new String(byArray, n, n2, charset);
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable String string) {
        return string == null ? 0 : CharsetManager.getUTF8ByteCount(string.toCharArray());
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nullable char[] cArray) {
        int n = 0;
        if (cArray != null) {
            for (char c : cArray) {
                n += CharsetManager.getUTF8ByteCount(c);
            }
        }
        return n;
    }

    @Nonnegative
    public static int getUTF8ByteCount(char c) {
        return CharsetManager.getUTF8ByteCount((int)c);
    }

    @Nonnegative
    public static int getUTF8ByteCount(@Nonnegative int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid parameter: " + n);
        }
        if (n == 0) {
            return 2;
        }
        if (n <= 127) {
            return 1;
        }
        if (n <= 2047) {
            return 2;
        }
        if (n <= 55295) {
            return 3;
        }
        return 0;
    }
}

