/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.charset;

import com.phloc.commons.IHasByteSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EUnicodeBOM implements IHasByteSize
{
    BOM_UTF_8(new byte[]{-17, -69, -65}),
    BOM_UTF_16_BIG_ENDIAN(new byte[]{-2, -1}),
    BOM_UTF_16_LITTLE_ENDIAN(new byte[]{-1, -2}),
    BOM_UTF_32_BIG_ENDIAN(new byte[]{0, 0, -2, -1}),
    BOM_UTF_32_LITTLE_ENDIAN(new byte[]{-1, -2, 0, 0}),
    BOM_UTF_7(new byte[]{43, 47, 118, 56}),
    BOM_UTF_7_ALT2(new byte[]{43, 47, 118, 57}),
    BOM_UTF_7_ALT3(new byte[]{43, 47, 118, 43}),
    BOM_UTF_7_ALT4(new byte[]{43, 47, 118, 47}),
    BOM_UTF_1(new byte[]{-9, 100, 76}),
    BOM_UTF_EBCDIC(new byte[]{-35, 115, 102, 115}),
    BOM_SCSU(new byte[]{14, -2, -1}),
    BOM_BOCU_1(new byte[]{-5, -18, 40}),
    BOM_BOCU_1_ALT2(new byte[]{-5, -18, 40, -1}),
    BOM_GB_18030(new byte[]{-124, 49, -107, 51});

    private final byte[] m_aBOMBytes;

    private EUnicodeBOM(byte[] byArray) {
        this.m_aBOMBytes = byArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getBytes() {
        return ArrayHelper.getCopy(this.m_aBOMBytes);
    }

    @Nonnegative
    public int getByteCount() {
        return this.m_aBOMBytes.length;
    }

    @Override
    @Nonnegative
    public long getSizeInBytes() {
        return this.m_aBOMBytes.length;
    }

    public boolean isPresent(@Nullable byte[] byArray) {
        int n = this.m_aBOMBytes.length;
        return byArray != null && byArray.length >= n && Arrays.equals(this.m_aBOMBytes, ArrayHelper.getCopy(byArray, 0, n));
    }
}

