/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.IByteArrayDecoder;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DCTCodec
implements IByteArrayDecoder {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DCTCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return DCTCodec.decodeDCT(byArray);
    }

    @Nullable
    public static byte[] decodeDCT(@Nullable byte[] byArray) {
        BufferedImage bufferedImage;
        if (byArray == null) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(new NonBlockingByteArrayInputStream(byArray));
            if (bufferedImage == null) {
                throw new DecoderException("Failed to read image");
            }
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Read DCT encoded image with " + byArray.length + " bytes");
            }
        }
        catch (Throwable throwable) {
            throw new DecoderException("Failed to read image", throwable);
        }
        int n = ((Image)bufferedImage).getWidth(null);
        int n2 = ((Image)bufferedImage).getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new DecoderException("Failed to grab pixels!");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DecoderException(interruptedException);
        }
        byte[] byArray2 = new byte[nArray.length * 3];
        for (int i = 0; i < nArray.length; ++i) {
            byArray2[i * 3] = (byte)(nArray[i] >> 24 & 0xFF);
            byArray2[i * 3 + 1] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray2[i * 3 + 2] = (byte)(nArray[i] >> 8 & 0xFF);
        }
        return byArray2;
    }
}

