/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.ICodec;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlateCodec
implements ICodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FlateCodec.class);

    private static boolean _isZlibHead(byte[] byArray) {
        if (byArray.length >= 2) {
            int n = byArray[0] & 0xFF;
            int n2 = byArray[1] & 0xFF;
            if ((n & 0xF) == 8 && (n >> 4) + 8 <= 15 && ((n << 8) + n2) % 31 == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return FlateCodec.decodeFlate(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] decodeFlate(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (!FlateCodec._isZlibHead(byArray)) {
            s_aLogger.warn("ZLib header not found");
        }
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new NonBlockingByteArrayInputStream(byArray));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            if (StreamUtils.copyInputStreamToOutputStream(inflaterInputStream, nonBlockingByteArrayOutputStream).isFailure()) {
                throw new DecoderException("Failed to flate decode!");
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamUtils.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        return FlateCodec.encodeFlate(byArray);
    }

    @Nullable
    public static byte[] encodeFlate(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(nonBlockingByteArrayOutputStream);
        if (StreamUtils.copyInputStreamToOutputStreamAndCloseOS(new NonBlockingByteArrayInputStream(byArray), deflaterOutputStream).isFailure()) {
            throw new EncoderException("Failed to flate encode!");
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }
}

