/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.ICodec;
import com.phloc.commons.codec.LZWDecodeDictionary;
import com.phloc.commons.codec.LZWEncodeDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.streams.NonBlockingBitInputStream;
import com.phloc.commons.io.streams.NonBlockingBitOutputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LZWCodec
implements ICodec {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LZWCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return LZWCodec.decodeLZW(byArray);
    }

    @Nullable
    public static byte[] decodeLZW(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        LZWCodec.decodeLZW(nonBlockingByteArrayInputStream, nonBlockingByteArrayOutputStream);
        StreamUtils.close(nonBlockingByteArrayOutputStream);
        StreamUtils.close(nonBlockingByteArrayInputStream);
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    public static void decodeLZW(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream) {
        block14: {
            if (inputStream == null) {
                throw new NullPointerException("encodedInputStream");
            }
            if (outputStream == null) {
                throw new NullPointerException("outputStream");
            }
            NonBlockingBitInputStream nonBlockingBitInputStream = new NonBlockingBitInputStream(inputStream, ByteOrder.LITTLE_ENDIAN);
            try {
                LZWDecodeDictionary lZWDecodeDictionary = new LZWDecodeDictionary();
                lZWDecodeDictionary.reset();
                int n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                while (n == 256) {
                    n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                }
                if (n == 257) break block14;
                byte[] byArray = lZWDecodeDictionary.getBytes(n);
                if (byArray == null) {
                    throw new DecoderException("Failed to resolve initial code " + n);
                }
                outputStream.write(byArray);
                byte[] byArray2 = byArray;
                while ((n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream)) != 257) {
                    if (n == 256) {
                        lZWDecodeDictionary.reset();
                        n = lZWDecodeDictionary.readCode(nonBlockingBitInputStream);
                        if (n != 257) {
                            byArray = lZWDecodeDictionary.getBytes(n);
                            outputStream.write(byArray);
                            byArray2 = byArray;
                            continue;
                        }
                        break;
                    }
                    int n2 = lZWDecodeDictionary.getNextFreeCode();
                    if (n < n2) {
                        byArray = lZWDecodeDictionary.getBytes(n);
                    } else if (n == n2) {
                        byArray = ArrayHelper.getConcatenated(byArray2, byArray2[0]);
                    } else {
                        throw new DecoderException("Error decoding LZW: unexpected code " + n + " while next free code is " + n2);
                    }
                    outputStream.write(byArray);
                    lZWDecodeDictionary.addEntry(ArrayHelper.getConcatenated(byArray2, byArray[0]), false);
                    byArray2 = byArray;
                }
            }
            catch (EOFException eOFException) {
                throw new DecoderException("Unexpected EOF decoding LZW", eOFException);
            }
            catch (IOException iOException) {
                throw new DecoderException("Error decoding LZW", iOException);
            }
        }
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        return LZWCodec.encodeLZW(byArray);
    }

    @Nullable
    public static byte[] encodeLZW(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        LZWCodec.encodeLZW(byArray, nonBlockingByteArrayOutputStream);
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    public static void encodeLZW(@Nullable byte[] byArray, @Nonnull @WillNotClose OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (byArray == null) {
            return;
        }
        NonBlockingBitOutputStream nonBlockingBitOutputStream = new NonBlockingBitOutputStream(outputStream, ByteOrder.LITTLE_ENDIAN);
        LZWEncodeDictionary lZWEncodeDictionary = new LZWEncodeDictionary();
        lZWEncodeDictionary.reset();
        try {
            int n;
            nonBlockingBitOutputStream.writeBits(256, lZWEncodeDictionary.getCodeLength());
            byte[] byArray2 = new byte[]{};
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                byArray2 = ArrayHelper.getConcatenated(byArray2, by);
                lZWEncodeDictionary.visit(by);
                int n2 = lZWEncodeDictionary.getCodeLength();
                LZWNode lZWNode = lZWEncodeDictionary.getNode(byArray2);
                if (n + 1 == byArray.length) {
                    nonBlockingBitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    break;
                }
                if (lZWNode.getChildNode(byArray[n + 1]) == null) {
                    nonBlockingBitOutputStream.writeBits(lZWNode.getTableIndex(), n2);
                    byArray2 = new byte[]{};
                }
                if (lZWEncodeDictionary.getNextFreeCode() != 4095) continue;
                if (s_aLogger.isTraceEnabled()) {
                    s_aLogger.trace("Table overflow in encoding -> resetting (codelength=" + n2 + ";byteseq#=" + byArray2.length + ")");
                }
                nonBlockingBitOutputStream.writeBits(256, n2);
                lZWEncodeDictionary.reset();
                n -= byArray2.length;
                byArray2 = new byte[]{};
            }
            n = lZWEncodeDictionary.getCodeLength();
            switch (lZWEncodeDictionary.getNextFreeCode()) {
                case 511: 
                case 1023: 
                case 2047: {
                    ++n;
                    if (!s_aLogger.isDebugEnabled()) break;
                    s_aLogger.debug("EOF char gets a new code length: " + n);
                    break;
                }
            }
            nonBlockingBitOutputStream.writeBits(257, n);
        }
        catch (Throwable throwable) {
            throw new EncoderException("Error encoding LZW", throwable);
        }
        finally {
            StreamUtils.flush(nonBlockingBitOutputStream);
        }
    }
}

