/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.AbstractLZWDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class LZWEncodeDictionary
extends AbstractLZWDictionary {
    private final LZWNode m_aRoot = new LZWNode();
    private final NonBlockingByteArrayOutputStream m_aByteBuf = new NonBlockingByteArrayOutputStream();

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < 256; ++i) {
            this.m_aRoot.setChildNode((byte)i, new LZWNode(i));
        }
        this.m_aByteBuf.reset();
    }

    public int getCodeLength() {
        return this.m_nCodeBits;
    }

    public boolean visit(byte by) {
        this.m_aByteBuf.write(by);
        LZWNode lZWNode = this.m_aRoot;
        for (byte by2 : this.m_aByteBuf.toByteArray()) {
            LZWNode lZWNode2 = lZWNode;
            if ((lZWNode = lZWNode.getChildNode(by2)) != null) continue;
            lZWNode2.setChildNode(by2, new LZWNode(this.m_nFreeCode));
            this.addEntry(this.m_aByteBuf.toByteArray(), true);
            this.m_aByteBuf.reset();
            this.m_aByteBuf.write(by);
            return true;
        }
        return false;
    }

    @Nullable
    public LZWNode getNode(@Nonnull byte[] byArray) {
        return this.m_aRoot.getChildNode(byArray);
    }
}

