/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.typeconvert.TypeConverter;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractReadonlyAttributeContainer
implements IReadonlyAttributeContainer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractReadonlyAttributeContainer.class);

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String string) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(string));
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String string, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getCastedAttribute(string);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable String string, @Nonnull Class<DATATYPE> clazz) {
        return TypeConverter.convertIfNecessary(this.getAttributeObject(string), clazz);
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getTypedAttribute(@Nullable String string, @Nonnull Class<DATATYPE> clazz, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getTypedAttribute(string, clazz);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String string) {
        return this.getAttributeAsString(string, null);
    }

    @Nullable
    public static final String getAsString(@Nullable String string, @Nullable Object object, @Nullable String string2) {
        if (object == null) {
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            Object[] objectArray = (String[])object;
            s_aLogger.warn("The parameter '" + string + "' is an array with " + objectArray.length + " items; using the first one if possible: " + Arrays.toString(objectArray));
            return objectArray.length > 0 ? objectArray[0] : string2;
        }
        return object.toString();
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String string, @Nullable String string2) {
        Object object = this.getAttributeObject(string);
        return AbstractReadonlyAttributeContainer.getAsString(string, object, string2);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String string) {
        return this.getAttributeAsInt(string, -1);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String string, int n) {
        Object object = this.getAttributeObject(string);
        if (object == null) {
            return n;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return StringParser.parseInt(AbstractReadonlyAttributeContainer.getAsString(string, object, null), n);
    }

    @Override
    public final long getAttributeAsLong(@Nullable String string) {
        return this.getAttributeAsLong(string, -1L);
    }

    @Override
    public final long getAttributeAsLong(@Nullable String string, long l) {
        Object object = this.getAttributeObject(string);
        if (object == null) {
            return l;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return StringParser.parseLong(AbstractReadonlyAttributeContainer.getAsString(string, object, null), l);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String string) {
        return this.getAttributeAsDouble(string, -1.0);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String string, double d) {
        Object object = this.getAttributeObject(string);
        if (object == null) {
            return d;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return StringParser.parseDouble(AbstractReadonlyAttributeContainer.getAsString(string, object, null), d);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String string) {
        return this.getAttributeAsBoolean(string, false);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String string, boolean bl) {
        Object object = this.getAttributeObject(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return StringParser.parseBool(AbstractReadonlyAttributeContainer.getAsString(string, object, null), bl);
    }
}

