/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.attrs.AbstractReadonlyAttributeContainer;
import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MapBasedReadonlyAttributeContainer
extends AbstractReadonlyAttributeContainer {
    private final Map<String, Object> m_aAttrs;

    public MapBasedReadonlyAttributeContainer(@Nonnull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        this.m_aAttrs = ContainerHelper.newMap(map);
    }

    public MapBasedReadonlyAttributeContainer(@Nonnull IReadonlyAttributeContainer iReadonlyAttributeContainer) {
        if (iReadonlyAttributeContainer == null) {
            throw new NullPointerException("Cont");
        }
        this.m_aAttrs = ContainerHelper.newMap(iReadonlyAttributeContainer.getAllAttributes());
    }

    @Override
    public boolean containsAttribute(@Nullable String string) {
        return this.m_aAttrs.containsKey(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, Object> getAllAttributes() {
        return ContainerHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nonnull
    public Enumeration<String> getAttributeNames() {
        return ContainerHelper.getEnumeration(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllAttributeNames() {
        return ContainerHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<Object> getAllAttributeValues() {
        return ContainerHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nullable
    public Object getAttributeObject(@Nullable String string) {
        return this.m_aAttrs.get(string);
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MapBasedReadonlyAttributeContainer)) {
            return false;
        }
        MapBasedReadonlyAttributeContainer mapBasedReadonlyAttributeContainer = (MapBasedReadonlyAttributeContainer)object;
        return ((Object)this.m_aAttrs).equals(mapBasedReadonlyAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aAttrs).toString();
    }
}

