/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorDouble {
    private final double[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorDouble(double ... dArray) {
        this(dArray, 0, dArray.length);
    }

    public ArrayIteratorDouble(@Nonnull double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        if (dArray == null) {
            throw new NullPointerException("array");
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        this.m_nIndex = 0;
        int n3 = n2 - n;
        this.m_aArray = ArrayHelper.getCopy(dArray, n, n3);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public double next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayIteratorDouble)) {
            return false;
        }
        ArrayIteratorDouble arrayIteratorDouble = (ArrayIteratorDouble)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorDouble.m_aArray) && this.m_nIndex == arrayIteratorDouble.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }
}

