/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.annotations.IsLocked;
import com.phloc.commons.cache.AbstractNotifyingCache;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.system.SystemHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CollatorUtils {
    private static final CollatorCache s_aCache = new CollatorCache();
    private static final CollatorUtils s_aInstance = new CollatorUtils();

    private CollatorUtils() {
    }

    @Nonnull
    public static Collator getCollatorSpaceBeforeDot(@Nullable Locale locale) {
        Locale locale2 = locale == null ? SystemHelper.getSystemLocale() : locale;
        return (Collator)((Collator)s_aCache.getFromCache(locale2)).clone();
    }

    @Nonnull
    public static EChange clearCache() {
        return s_aCache.clearCache();
    }

    @ThreadSafe
    private static final class CollatorCache
    extends AbstractNotifyingCache<Locale, Collator> {
        private static final Logger s_aLogger = LoggerFactory.getLogger(CollatorCache.class);

        public CollatorCache() {
            super(CollatorUtils.class.getName());
        }

        @Override
        @Nonnull
        @IsLocked(value=IsLocked.ELockType.WRITE)
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
        protected Collator getValueToCache(@Nullable Locale locale) {
            if (locale == null) {
                s_aLogger.error("Very weird: no locale passed in. Falling back to system locale.");
                return Collator.getInstance(SystemHelper.getSystemLocale());
            }
            Collator collator = Collator.getInstance(locale);
            if (collator == null) {
                s_aLogger.error("Failed to get Collator for Locale " + locale + " - using Collator for default locale!");
                return Collator.getInstance(SystemHelper.getSystemLocale());
            }
            if (!(collator instanceof RuleBasedCollator)) {
                s_aLogger.warn("Collator.getInstance did not return a RulleBasedCollator but a " + collator.getClass().getName());
                return collator;
            }
            try {
                String string = ((RuleBasedCollator)collator).getRules();
                if (string.indexOf("<'.'<") < 0) {
                    s_aLogger.warn("Failed to identify the Collator rule part to be replaced. Locale used: " + locale);
                    return collator;
                }
                String string2 = StringHelper.replaceAll(string, "<'.'<", "<' '<'.'<");
                RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(string2);
                ruleBasedCollator.setStrength(2);
                ruleBasedCollator.setDecomposition(2);
                return ruleBasedCollator;
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("Failed to parse collator rule set for locale " + locale, parseException);
            }
        }
    }
}

