/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.deadlock;

import com.phloc.commons.deadlock.IThreadDeadlockListener;
import com.phloc.commons.deadlock.ThreadDeadlockDetector;
import com.phloc.commons.state.EChange;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ThreadDeadlockDetectionTimer {
    private static final long DEFAULT_DEADLOCK_CHECK_PERIOD = 10000L;
    private static final long INITIAL_DELAY_MS = 10L;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ThreadDeadlockDetectionTimer.class);
    private final ThreadDeadlockDetector m_aTLD = new ThreadDeadlockDetector();
    private final TimerTask m_aTimerTask;
    private final Timer m_aThreadCheck = new Timer("ThreadDeadlockDetector", true);

    public ThreadDeadlockDetectionTimer() {
        this(10000L);
    }

    public ThreadDeadlockDetectionTimer(@Nonnegative long l) {
        this.m_aTimerTask = new TimerTask(){

            @Override
            public void run() {
                ThreadDeadlockDetectionTimer.this.m_aTLD.run();
            }
        };
        this.m_aThreadCheck.schedule(this.m_aTimerTask, 10L, l);
        s_aLogger.info("Deadlock detector started!");
    }

    public void stop() {
        if (this.m_aTimerTask.cancel()) {
            s_aLogger.info("Deadlock detector stopped!");
        }
    }

    @Nonnull
    public EChange addListener(@Nonnull IThreadDeadlockListener iThreadDeadlockListener) {
        return this.m_aTLD.addListener(iThreadDeadlockListener);
    }

    @Nonnull
    public EChange removeListener(@Nullable IThreadDeadlockListener iThreadDeadlockListener) {
        return this.m_aTLD.removeListener(iThreadDeadlockListener);
    }

    @Nonnull
    public EChange removeAllListeners() {
        return this.m_aTLD.removeAllListeners();
    }

    @Nonnegative
    public int getListenerCount() {
        return this.m_aTLD.getListenerCount();
    }
}

