/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.annotations.UseDirectEqualsAndHashCode;
import com.phloc.commons.equals.IEqualsImplementation;
import com.phloc.commons.equals.IEqualsImplementationRegistrarSPI;
import com.phloc.commons.equals.IEqualsImplementationRegistry;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.ClassHierarchyCache;
import com.phloc.commons.lang.ServiceLoaderUtils;
import com.phloc.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EqualsImplementationRegistry
implements IEqualsImplementationRegistry {
    private static final Logger s_aLogger = LoggerFactory.getLogger(EqualsImplementationRegistry.class);
    private static final EqualsImplementationRegistry s_aInstance = new EqualsImplementationRegistry();
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Map<Class<?>, IEqualsImplementation> m_aMap = new WeakHashMap();
    private final Map<String, Boolean> m_aDirectEquals = new HashMap<String, Boolean>();
    private final Map<String, Boolean> m_aImplementsEquals = new HashMap<String, Boolean>();

    private EqualsImplementationRegistry() {
        for (IEqualsImplementationRegistrarSPI iEqualsImplementationRegistrarSPI : ServiceLoaderUtils.getAllSPIImplementations(IEqualsImplementationRegistrarSPI.class)) {
            iEqualsImplementationRegistrarSPI.registerEqualsImplementations(this);
        }
    }

    @Nonnull
    public static EqualsImplementationRegistry getInstance() {
        return s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEqualsImplementation(@Nonnull Class<?> clazz, @Nonnull IEqualsImplementation iEqualsImplementation) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (iEqualsImplementation == null) {
            throw new NullPointerException("implementation");
        }
        if (clazz.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide an equals implementation for Object.class!");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aMap.containsKey(clazz)) {
                s_aLogger.warn("Another equals implementation for class " + clazz + " is already implemented!");
            } else {
                this.m_aMap.put(clazz, iEqualsImplementation);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange unregisterEqualsImplementation(@Nonnull Class<?> clazz) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMap.remove(clazz) != null);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isUseDirectEquals(@Nonnull Class<?> clazz) {
        Boolean bl;
        String string = clazz.getName();
        this.m_aRWLock.readLock().lock();
        try {
            bl = this.m_aDirectEquals.get(string);
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        if (bl == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                bl = this.m_aDirectEquals.get(string);
                if (bl == null) {
                    boolean bl2 = clazz.getAnnotation(UseDirectEqualsAndHashCode.class) != null;
                    bl = bl2;
                    this.m_aDirectEquals.put(string, bl);
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _implementsEqualsItself(@Nonnull Class<?> clazz) {
        Boolean bl;
        block11: {
            String string = clazz.getName();
            this.m_aRWLock.readLock().lock();
            try {
                bl = this.m_aImplementsEquals.get(string);
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
            if (bl == null) {
                this.m_aRWLock.writeLock().lock();
                try {
                    bl = this.m_aImplementsEquals.get(string);
                    if (bl != null) break block11;
                    boolean bl2 = false;
                    try {
                        Method method = clazz.getDeclaredMethod("equals", Object.class);
                        if (method != null && method.getReturnType().equals(Boolean.TYPE)) {
                            bl2 = true;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    bl = bl2;
                    this.m_aImplementsEquals.put(string, bl);
                }
                finally {
                    this.m_aRWLock.writeLock().unlock();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IEqualsImplementation getBestMatchingEqualsImplementation(@Nullable Class<?> clazz) {
        if (clazz != null) {
            Class clazz2;
            IEqualsImplementation iEqualsImplementation;
            block19: {
                iEqualsImplementation = null;
                clazz2 = null;
                if (this._isUseDirectEquals(clazz)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    iEqualsImplementation = this.m_aMap.get(clazz);
                    if (iEqualsImplementation != null) {
                        clazz2 = clazz;
                        break block19;
                    }
                    for (WeakReference<Class<?>> weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                        IEqualsImplementation iEqualsImplementation2;
                        Class clazz3 = (Class)weakReference.get();
                        if (clazz3 == null || (iEqualsImplementation2 = this.m_aMap.get(clazz3)) == null) continue;
                        iEqualsImplementation = iEqualsImplementation2;
                        clazz2 = clazz3;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Found hierarchical match with class " + clazz2 + " when searching for " + clazz);
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (iEqualsImplementation != null) {
                if (ClassHelper.isInterface(clazz2) && this._implementsEqualsItself(clazz)) {
                    this.m_aRWLock.writeLock().lock();
                    try {
                        this.m_aDirectEquals.put(clazz.getName(), Boolean.TRUE);
                    }
                    finally {
                        this.m_aRWLock.writeLock().unlock();
                    }
                    return null;
                }
                if (!clazz2.equals(clazz)) {
                    this.registerEqualsImplementation(clazz, iEqualsImplementation);
                }
                return iEqualsImplementation;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return new ArrayEqualsImplementation();
            }
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aDirectEquals.put(clazz.getName(), Boolean.TRUE);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Found no equals implementation for " + clazz);
        }
        return null;
    }

    public static <T> boolean areEqual(@Nullable T t, @Nullable T t2) {
        Class<?> clazz;
        if (t == t2) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        Class<?> clazz2 = t.getClass();
        if (!clazz2.equals(clazz = t2.getClass())) {
            return false;
        }
        IEqualsImplementation iEqualsImplementation = s_aInstance.getBestMatchingEqualsImplementation(clazz2);
        boolean bl = iEqualsImplementation == null ? t.equals(t2) : iEqualsImplementation.areEqual(t, t2);
        return bl;
    }

    private static final class ArrayEqualsImplementation
    implements IEqualsImplementation {
        @Override
        public boolean areEqual(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])object2;
            if (n != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (EqualsImplementationRegistry.areEqual(objectArray[i], objectArray2[i])) continue;
                return false;
            }
            return true;
        }
    }
}

