/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.error.IResourceLocation;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResourceLocation
implements IResourceLocation {
    private final String m_sResourceID;
    private final int m_nLineNumber;
    private final int m_nColumnNumber;
    private final String m_sField;

    public ResourceLocation(@Nullable String string) {
        this(string, null);
    }

    public ResourceLocation(@Nullable String string, @Nullable String string2) {
        this(string, -1, -1, string2);
    }

    public ResourceLocation(@Nullable String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ResourceLocation(@Nullable String string, int n, int n2, @Nullable String string2) {
        this.m_sResourceID = string;
        this.m_nLineNumber = n;
        this.m_nColumnNumber = n2;
        this.m_sField = string2;
    }

    @Override
    @Nullable
    public String getResourceID() {
        return this.m_sResourceID;
    }

    @Override
    public int getLineNumber() {
        return this.m_nLineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.m_nColumnNumber;
    }

    @Override
    @Nullable
    public String getField() {
        return this.m_sField;
    }

    @Override
    @Nonnull
    public String getAsString() {
        String string = "";
        if (this.m_sResourceID != null) {
            string = string + this.m_sResourceID;
        }
        if (this.m_nLineNumber != -1) {
            string = this.m_nColumnNumber != -1 ? string + "(" + this.m_nLineNumber + ":" + this.m_nColumnNumber + ")" : string + "(" + this.m_nLineNumber + ":?)";
        }
        if (this.m_sField != null) {
            if (string.length() > 0) {
                string = string + " @ ";
            }
            string = string + this.m_sField;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourceLocation = (ResourceLocation)object;
        return EqualsUtils.equals(this.m_sResourceID, resourceLocation.m_sResourceID) && this.m_nLineNumber == resourceLocation.m_nLineNumber && this.m_nColumnNumber == resourceLocation.m_nColumnNumber && EqualsUtils.equals(this.m_sField, resourceLocation.m_sField);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sResourceID).append(this.m_nLineNumber).append(this.m_nColumnNumber).append(this.m_sField).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("resourceID", this.m_sResourceID).append("lineNumber", this.m_nLineNumber).append("columnNumber", this.m_nColumnNumber).appendIfNotNull("field", this.m_sField).toString();
    }
}

