/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format.impl;

import com.phloc.commons.format.IFormatter;
import com.phloc.commons.format.impl.AbstractStringFormatter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringSkipPrefixAndSuffixFormatter
extends AbstractStringFormatter {
    private final String m_sPrefix;
    private final String m_sSuffix;

    public StringSkipPrefixAndSuffixFormatter(@Nonnull String string, @Nonnull String string2) {
        this(null, string, string2);
    }

    public StringSkipPrefixAndSuffixFormatter(@Nullable IFormatter iFormatter, @Nonnull String string, @Nonnull String string2) {
        super(iFormatter);
        if (string == null) {
            throw new NullPointerException("prefix");
        }
        if (string2 == null) {
            throw new NullPointerException("suffix");
        }
        this.m_sPrefix = string;
        this.m_sSuffix = string2;
    }

    @Override
    protected final String getFormattedValueAsString(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (!this.m_sPrefix.isEmpty()) {
            string = StringHelper.trimStart(string, this.m_sPrefix);
        }
        if (!this.m_sSuffix.isEmpty()) {
            string = StringHelper.trimEnd(string, this.m_sSuffix);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StringSkipPrefixAndSuffixFormatter)) {
            return false;
        }
        StringSkipPrefixAndSuffixFormatter stringSkipPrefixAndSuffixFormatter = (StringSkipPrefixAndSuffixFormatter)object;
        return this.m_sPrefix.equals(stringSkipPrefixAndSuffixFormatter.m_sPrefix) && this.m_sSuffix.equals(stringSkipPrefixAndSuffixFormatter.m_sSuffix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_sSuffix).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", this.m_sPrefix).append("suffix", this.m_sSuffix).toString();
    }
}

