/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.i18n;

import com.phloc.commons.i18n.AbstractCodepointIterator;
import com.phloc.commons.i18n.Codepoint;
import com.phloc.commons.i18n.DelegatingCodepointIterator;
import com.phloc.commons.i18n.ICodepointFilter;
import com.phloc.commons.i18n.InvalidCharacterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CodepointIteratorRestricted
extends DelegatingCodepointIterator {
    private final ICodepointFilter m_aFilter;
    private final boolean m_bScanningOnly;
    private final boolean m_bInvert;

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull ICodepointFilter iCodepointFilter) {
        this(abstractCodepointIterator, iCodepointFilter, false);
    }

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull ICodepointFilter iCodepointFilter, boolean bl) {
        this(abstractCodepointIterator, iCodepointFilter, bl, false);
    }

    public CodepointIteratorRestricted(@Nonnull AbstractCodepointIterator abstractCodepointIterator, @Nonnull ICodepointFilter iCodepointFilter, boolean bl, boolean bl2) {
        super(abstractCodepointIterator);
        if (iCodepointFilter == null) {
            throw new NullPointerException("filter");
        }
        this.m_aFilter = iCodepointFilter;
        this.m_bScanningOnly = bl;
        this.m_bInvert = bl2;
    }

    @Override
    public boolean hasNext() {
        boolean bl = super.hasNext();
        if (this.m_bScanningOnly) {
            try {
                int n = this.peek(this.position()).getValue();
                if (bl && n != -1 && this._doFilter(n)) {
                    return false;
                }
            }
            catch (InvalidCharacterException invalidCharacterException) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public Codepoint next() {
        Codepoint codepoint = super.next();
        int n = codepoint.getValue();
        if (n != -1 && this._doFilter(n)) {
            if (this.m_bScanningOnly) {
                this.position(this.position() - 1);
                return null;
            }
            throw new InvalidCharacterException(n);
        }
        return codepoint;
    }

    private boolean _doFilter(int n) {
        boolean bl = this.m_aFilter.accept(n);
        return this.m_bInvert ? !bl : bl;
    }

    @Override
    @Nullable
    public char[] nextChars() {
        char[] cArray = super.nextChars();
        if (cArray != null && cArray.length > 0) {
            int n;
            if (cArray.length == 1 && this._doFilter(cArray[0])) {
                if (this.m_bScanningOnly) {
                    this.position(this.position() - 1);
                    return null;
                }
                throw new InvalidCharacterException(cArray[0]);
            }
            if (cArray.length == 2 && this._doFilter(n = Character.toCodePoint(cArray[0], cArray[1]))) {
                if (this.m_bScanningOnly) {
                    this.position(this.position() - 2);
                    return null;
                }
                throw new InvalidCharacterException(n);
            }
        }
        return cArray;
    }
}

