/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.mutable.IWrapper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.commons.url.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLResource
implements IReadableResource {
    public static final String PROTOCOL_FILE = "file";
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLResource.class);
    private final URL m_aURL;

    public URLResource(@Nonnull ISimpleURL iSimpleURL) throws MalformedURLException {
        this(iSimpleURL.getAsString());
    }

    public URLResource(@Nonnull String string) throws MalformedURLException {
        this(new URL(string));
    }

    public URLResource(@Nonnull URI uRI) throws MalformedURLException {
        this(uRI.toURL());
    }

    public URLResource(@Nonnull URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("URL");
        }
        this.m_aURL = uRL;
    }

    public static boolean isExplicitURLResource(@Nullable String string) {
        return URLUtils.getAsURL(string) != null;
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_aURL.toExternalForm();
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL) {
        return URLResource.getInputStream(uRL, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL, @Nullable Map<String, String> map, @Nullable IWrapper<IOException> iWrapper) {
        if (uRL == null) {
            throw new NullPointerException("URL");
        }
        URLConnection uRLConnection = null;
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    uRLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            if (iWrapper != null) {
                iWrapper.set(iOException);
            } else {
                s_aLogger.warn("Failed to open input stream for '" + uRL + "': " + iOException.getClass().getName() + " - " + iOException.getMessage());
            }
            if (uRLConnection instanceof HttpURLConnection) {
                InputStream inputStream = null;
                try {
                    inputStream = ((HttpURLConnection)uRLConnection).getErrorStream();
                    if (inputStream != null) {
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) > 0) {
                        }
                    }
                }
                catch (IOException iOException2) {
                    s_aLogger.warn("Failed to consume error stream for '" + uRL + "': " + iOException2.getClass().getName() + " - " + iOException2.getMessage());
                }
                finally {
                    StreamUtils.close(inputStream);
                }
            }
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return URLResource.getInputStream(this.m_aURL);
    }

    @Nullable
    public InputStream getInputStream(@Nullable Map<String, String> map) {
        return URLResource.getInputStream(this.m_aURL, map, null);
    }

    @Nullable
    public InputStream getInputStream(@Nullable IWrapper<IOException> iWrapper) {
        return URLResource.getInputStream(this.m_aURL, null, iWrapper);
    }

    @Nullable
    public InputStream getInputStream(@Nullable Map<String, String> map, @Nullable IWrapper<IOException> iWrapper) {
        return URLResource.getInputStream(this.m_aURL, map, iWrapper);
    }

    @Override
    @Nullable
    @Deprecated
    public Reader getReader(@Nonnull String string) {
        return StreamUtils.createReader(this.getInputStream(), string);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return StreamUtils.createReader(this.getInputStream(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if (PROTOCOL_FILE.equals(this.m_aURL.getProtocol())) {
            return this.getAsFile().exists();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            boolean bl = inputStream != null;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.close(inputStream);
        }
    }

    @Override
    @Nonnull
    public URL getAsURL() {
        return this.m_aURL;
    }

    @Nullable
    public URI getAsURI() {
        return URLUtils.getAsURI(this.m_aURL);
    }

    @Nonnull
    public static File getAsFile(@Nonnull URL uRL) {
        File file;
        if (uRL == null) {
            throw new NullPointerException("URL");
        }
        if (!PROTOCOL_FILE.equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("Not a file URL: " + uRL);
        }
        try {
            file = new File(uRL.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        return file;
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return URLResource.getAsFile(this.m_aURL);
    }

    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull URL uRL) {
        return new URLResource(uRL);
    }

    @Override
    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull String string) {
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot convert to an URL: " + string, malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URLResource)) {
            return false;
        }
        URLResource uRLResource = (URLResource)object;
        return EqualsUtils.equals(this.m_aURL, uRLResource.m_aURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("url", this.m_aURL).toString();
    }
}

