/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamAndReaderProvider;
import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StringInputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringInputStreamProvider
implements IInputStreamAndReaderProvider,
IReaderProvider {
    private final String m_sData;
    private final Charset m_aCharset;

    @Deprecated
    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull @Nonempty String string) {
        this(new String(cArray), string);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull Charset charset) {
        this(new String(cArray), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty String string) {
        this(new String(cArray, n, n2), string);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        this(new String(cArray, n, n2), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull @Nonempty String string) {
        this(((Object)charSequence).toString(), string);
    }

    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull Charset charset) {
        this(((Object)charSequence).toString(), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull String string, @Nonnull @Nonempty String string2) {
        this(string, CharsetManager.getCharsetFromName(string2));
    }

    public StringInputStreamProvider(@Nonnull String string, @Nonnull Charset charset) {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.m_sData = string;
        this.m_aCharset = charset;
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nonnull
    public final StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    @Nonnull
    @Deprecated
    public final NonBlockingStringReader getReader(@Nonnull String string) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull Charset charset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).toString();
    }
}

