/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class ByteBufferOutputStream
extends OutputStream {
    public static final int DEFAULT_BUF_SIZE = 1024;
    public static final boolean DEFAULT_CAN_GROW = true;
    private ByteBuffer m_aBuffer;
    private final boolean m_bCanGrow;

    public ByteBufferOutputStream() {
        this(1024, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n) {
        this(n, true);
    }

    public ByteBufferOutputStream(@Nonnegative int n, boolean bl) {
        this(ByteBuffer.allocate(n), bl);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray) {
        this(ByteBuffer.wrap(byArray), false);
    }

    public ByteBufferOutputStream(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(ByteBuffer.wrap(byArray, n, n2), false);
    }

    public ByteBufferOutputStream(@Nonnull ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer == null) {
            throw new NullPointerException("buffer");
        }
        this.m_aBuffer = byteBuffer;
        this.m_bCanGrow = bl;
    }

    @Nonnull
    public ByteBuffer getBuffer() {
        return this.m_aBuffer;
    }

    public boolean canGrow() {
        return this.m_bCanGrow;
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.m_aBuffer.clear();
    }

    @Nonnegative
    public int size() {
        return this.m_aBuffer.position();
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAsByteArray() {
        byte[] byArray = this.m_aBuffer.array();
        int n = this.m_aBuffer.arrayOffset();
        int n2 = this.m_aBuffer.position();
        return ArrayHelper.getCopy(byArray, n, n2);
    }

    public void writeTo(@Nonnull ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("destBuffer");
        }
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        this.m_aBuffer.compact();
    }

    public void writeTo(@Nonnull byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        this.writeTo(byArray, 0, byArray.length);
    }

    public void writeTo(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("ofs:" + n + ";len=" + n2 + ";bufLen=" + byArray.length);
        }
        this.m_aBuffer.flip();
        this.m_aBuffer.get(byArray, n, n2);
        this.m_aBuffer.compact();
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        outputStream.write(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position());
        this.m_aBuffer.clear();
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return new String(this.m_aBuffer.array(), this.m_aBuffer.arrayOffset(), this.m_aBuffer.position(), charset);
    }

    private void _growBy(@Nonnegative int n) {
        int n2 = this.m_aBuffer.capacity();
        int n3 = Math.max(n2 << 1, n2 + n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        this.m_aBuffer.flip();
        byteBuffer.put(this.m_aBuffer);
        this.m_aBuffer = byteBuffer;
    }

    @Override
    public void write(int n) {
        if (this.m_bCanGrow && !this.m_aBuffer.hasRemaining()) {
            this._growBy(1);
        }
        this.m_aBuffer.put((byte)n);
    }

    @Override
    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_bCanGrow && n2 > this.m_aBuffer.remaining()) {
            this._growBy(n2);
        }
        this.m_aBuffer.put(byArray, n, n2);
    }

    public void write(@Nonnull ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException("srcBuffer");
        }
        if (this.m_bCanGrow && byteBuffer.remaining() > this.m_aBuffer.remaining()) {
            this._growBy(byteBuffer.remaining());
        }
        this.m_aBuffer.put(byteBuffer);
    }
}

