/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingBitInputStream
implements Closeable {
    private InputStream m_aIS;
    private final boolean m_bHighOrderBitFirst;
    private int m_nNextBitIndex;
    private int m_nBuffer;

    public NonBlockingBitInputStream(@Nonnull InputStream inputStream, @Nonnull ByteOrder byteOrder) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        this.m_aIS = StreamUtils.getBuffered(inputStream);
        this.m_bHighOrderBitFirst = byteOrder.equals(ByteOrder.LITTLE_ENDIAN);
        this.m_nNextBitIndex = 8;
    }

    @Deprecated
    public NonBlockingBitInputStream(@Nonnull InputStream inputStream, boolean bl) {
        this(inputStream, bl ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
    }

    @Nonnull
    public ByteOrder getByteOrder() {
        return this.m_bHighOrderBitFirst ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public int readBits(@Nonnegative int n) throws IOException {
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Illegal number of bits passed!");
        }
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n2 |= this.readBit() << i;
        }
        return n2;
    }

    public int readBit() throws IOException {
        if (this.m_aIS == null) {
            throw new IOException("Already closed");
        }
        if (this.m_nNextBitIndex == 8) {
            this.m_nBuffer = this.m_aIS.read();
            if (this.m_nBuffer == -1) {
                throw new EOFException();
            }
            this.m_nNextBitIndex = 0;
        }
        int n = this.m_bHighOrderBitFirst ? 1 << 7 - this.m_nNextBitIndex : 1 << this.m_nNextBitIndex;
        int n2 = this.m_nBuffer & n;
        ++this.m_nNextBitIndex;
        return n2 == 0 ? 0 : 1;
    }

    @Override
    public void close() {
        StreamUtils.close(this.m_aIS);
        this.m_aIS = null;
    }

    public String toString() {
        return new ToStringGenerator(this).append("IS", this.m_aIS).append("highOrderBitFirst", this.m_bHighOrderBitFirst).append("nextBitIndex", this.m_nNextBitIndex).append("buffer", this.m_nBuffer).toString();
    }
}

