/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

public class NonBlockingByteArrayOutputStream
extends OutputStream
implements IHasSize,
Serializable {
    protected byte[] m_aBuf;
    protected int m_nCount;

    public NonBlockingByteArrayOutputStream() {
        this(32);
    }

    public NonBlockingByteArrayOutputStream(@Nonnegative int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.m_aBuf = new byte[n];
    }

    @Nonnull
    private static byte[] _enlarge(@Nonnull byte[] byArray, @Nonnegative int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    @Override
    public void write(int n) {
        int n2 = this.m_nCount + 1;
        if (n2 > this.m_aBuf.length) {
            this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n2));
        }
        this.m_aBuf[this.m_nCount] = (byte)n;
        this.m_nCount = n2;
    }

    @Override
    public void write(@Nonnull byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(@Nonnull byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("buf");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("ofs:" + n + ";len=" + n2 + ";bufLen=" + byArray.length);
        }
        if (n2 > 0) {
            int n3 = this.m_nCount + n2;
            if (n3 > this.m_aBuf.length) {
                this.m_aBuf = NonBlockingByteArrayOutputStream._enlarge(this.m_aBuf, Math.max(this.m_aBuf.length << 1, n3));
            }
            System.arraycopy(byArray, n, this.m_aBuf, this.m_nCount, n2);
            this.m_nCount = n3;
        }
    }

    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.m_aBuf, 0, this.m_nCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToAndClose(@Nonnull @WillClose OutputStream outputStream) throws IOException {
        try {
            this.writeTo(outputStream);
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }

    public void reset() {
        this.m_nCount = 0;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] toByteArray() {
        return ArrayHelper.getCopy(this.m_aBuf, this.m_nCount);
    }

    public byte getByteAt(@Nonnegative int n) {
        if (n < 0 || n >= this.m_nCount) {
            throw new IllegalArgumentException("Illegal index passed!");
        }
        return this.m_aBuf[n];
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nCount;
    }

    @Nonnegative
    public int getBufferSize() {
        return this.m_aBuf.length;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nCount == 0;
    }

    public boolean isNotEmpty() {
        return this.m_nCount > 0;
    }

    public boolean startsWith(@Nonnull byte[] byArray) {
        return this.startsWith(byArray, 0, byArray.length);
    }

    public boolean startsWith(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (this.m_nCount < n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.m_aBuf[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    @Deprecated
    public String getAsString(@Nonnull String string) {
        return CharsetManager.getAsString(this.m_aBuf, 0, this.m_nCount, string);
    }

    @Nonnull
    @Deprecated
    public String getAsString(@Nonnegative int n, @Nonnull String string) {
        if (n < 0 || n > this.m_nCount) {
            throw new IllegalArgumentException("Invalid length: " + n);
        }
        return CharsetManager.getAsString(this.m_aBuf, 0, n, string);
    }

    @Nonnull
    @Deprecated
    public String getAsString(@Nonnegative int n, @Nonnegative int n2, @Nonnull String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        if (n2 < 0 || n2 > this.m_nCount) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        return CharsetManager.getAsString(this.m_aBuf, n, n2, string);
    }

    @Nonnull
    public String getAsString(@Nonnull Charset charset) {
        return CharsetManager.getAsString(this.m_aBuf, 0, this.m_nCount, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnull Charset charset) {
        if (n < 0 || n > this.m_nCount) {
            throw new IllegalArgumentException("Invalid length: " + n);
        }
        return CharsetManager.getAsString(this.m_aBuf, 0, n, charset);
    }

    @Nonnull
    public String getAsString(@Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        if (n2 < 0 || n2 > this.m_nCount) {
            throw new IllegalArgumentException("Invalid length: " + n2);
        }
        return CharsetManager.getAsString(this.m_aBuf, n, n2, charset);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return new ToStringGenerator(this).append("buf#", ArrayHelper.getSize(this.m_aBuf)).append("size", this.m_nCount).toString();
    }
}

