/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WrappedWriter
extends Writer {
    private final Writer m_aWrappedWriter;

    public WrappedWriter(@Nonnull Writer writer) {
        if (writer == null) {
            throw new NullPointerException("wrappedWriter");
        }
        this.m_aWrappedWriter = writer;
    }

    @Nonnull
    public Writer getWrappedWriter() {
        return this.m_aWrappedWriter;
    }

    @Override
    public void write(int n) throws IOException {
        this.m_aWrappedWriter.write(n);
    }

    @Override
    public void write(@Nonnull char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.m_aWrappedWriter.write(cArray, n, n2);
    }

    @Override
    public void write(@Nonnull String string) throws IOException {
        this.m_aWrappedWriter.write(string);
    }

    @Override
    public void write(@Nonnull String string, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.m_aWrappedWriter.write(string, n, n2);
    }

    @Override
    public WrappedWriter append(@Nullable CharSequence charSequence) throws IOException {
        this.m_aWrappedWriter.append(charSequence);
        return this;
    }

    @Override
    public WrappedWriter append(@Nullable CharSequence charSequence, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this.m_aWrappedWriter.append(charSequence, n, n2);
        return this;
    }

    @Override
    public WrappedWriter append(char c) throws IOException {
        this.m_aWrappedWriter.append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.m_aWrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_aWrappedWriter.close();
    }

    public String toString() {
        return new ToStringGenerator(this).append("wrappedWriter", this.m_aWrappedWriter).toString();
    }
}

