/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.lang.ClassHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ServiceLoaderUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ServiceLoaderUtils.class);

    private ServiceLoaderUtils() {
    }

    @Nonnull
    private static ClassLoader _getDefaultClassLoader() {
        return ClassHelper.getDefaultClassLoader();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz) {
        return ServiceLoaderUtils.getAllSPIImplementations(clazz, ServiceLoaderUtils._getDefaultClassLoader(), null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderUtils.getAllSPIImplementations(clazz, classLoader, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderUtils.getAllSPIImplementations(clazz, ServiceLoaderUtils._getDefaultClassLoader(), logger);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> List<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2;
        if (clazz == null) {
            throw new NullPointerException("SPIClass");
        }
        if (classLoader == null) {
            throw new NullPointerException("ClassLoader");
        }
        Logger logger3 = logger2 = logger != null ? logger : s_aLogger;
        if (logger2.isDebugEnabled()) {
            logger2.debug("Trying to load all SPI implementations of " + clazz);
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        ArrayList<T> arrayList = new ArrayList<T>();
        Iterator<T> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.add(iterator.next());
            }
            catch (Throwable throwable) {
                logger2.error("Unable to load an SPI implementation of " + clazz, throwable);
            }
        }
        if (logger2.isDebugEnabled() || GlobalDebug.isDebugMode()) {
            String string = "Finished loading all SPI implementations of " + clazz + " --> returning " + arrayList.size() + " instances";
            if (logger2.isDebugEnabled()) {
                logger2.debug(string);
            } else {
                logger2.info(string);
            }
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz) {
        return ServiceLoaderUtils.getFirstSPIImplementation(clazz, ServiceLoaderUtils._getDefaultClassLoader(), null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderUtils.getFirstSPIImplementation(clazz, classLoader, null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderUtils.getFirstSPIImplementation(clazz, ServiceLoaderUtils._getDefaultClassLoader(), logger);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2 = logger != null ? logger : s_aLogger;
        List<T> list = ServiceLoaderUtils.getAllSPIImplementations(clazz, classLoader, logger2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            logger2.warn("Requested only one SPI implementation of " + clazz + " but found " + list.size() + ": " + list);
        }
        return list.get(0);
    }
}

