/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LocaleFormatter {
    private static final LocaleFormatter s_aInstance = new LocaleFormatter();

    private LocaleFormatter() {
    }

    @Nonnull
    public static String getFormatted(double d, @Nonnull Locale locale) {
        return NumberFormat.getNumberInstance(locale).format(d);
    }

    @Nonnull
    public static String getFormatted(int n, @Nonnull Locale locale) {
        return NumberFormat.getIntegerInstance(locale).format(n);
    }

    @Nonnull
    public static String getFormatted(long l, @Nonnull Locale locale) {
        return NumberFormat.getIntegerInstance(locale).format(l);
    }

    @Nonnull
    public static String getFormattedPercent(double d, @Nonnull Locale locale) {
        return NumberFormat.getPercentInstance(locale).format(d);
    }

    @Nonnull
    public static String getFormattedPercent(double d, @Nonnegative int n, @Nonnull Locale locale) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }

    @Nullable
    public static Number parse(String string, @Nonnull Locale locale) {
        return LocaleFormatter.parse(string, NumberFormat.getInstance(locale));
    }

    @Nullable
    public static Number parse(@Nullable String string, @Nonnull NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullPointerException("numberFormat");
        }
        if (string != null) {
            try {
                return numberFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static float parseFloat(@Nullable String string, @Nonnull Locale locale, float f) {
        return LocaleFormatter.parseFloat(string, NumberFormat.getInstance(locale), f);
    }

    public static float parseFloat(@Nullable String string, @Nonnull NumberFormat numberFormat, float f) {
        Number number = LocaleFormatter.parse(string, numberFormat);
        return number == null ? f : number.floatValue();
    }

    public static double parseDouble(@Nullable String string, @Nonnull Locale locale, double d) {
        return LocaleFormatter.parseDouble(string, NumberFormat.getInstance(locale), d);
    }

    public static double parseDouble(@Nullable String string, @Nonnull NumberFormat numberFormat, double d) {
        Number number = LocaleFormatter.parse(string, numberFormat);
        return number == null ? d : number.doubleValue();
    }

    public static int parseInt(@Nullable String string, @Nonnull Locale locale, int n) {
        return LocaleFormatter.parseInt(string, NumberFormat.getIntegerInstance(locale), n);
    }

    public static int parseInt(@Nullable String string, @Nonnull NumberFormat numberFormat, int n) {
        Number number = LocaleFormatter.parse(string, numberFormat);
        return number == null ? n : number.intValue();
    }

    public static long parseLong(@Nullable String string, @Nonnull Locale locale, long l) {
        return LocaleFormatter.parseLong(string, NumberFormat.getIntegerInstance(locale), l);
    }

    public static long parseLong(@Nullable String string, @Nonnull NumberFormat numberFormat, long l) {
        Number number = LocaleFormatter.parse(string, numberFormat);
        return number == null ? l : number.longValue();
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            throw new NullPointerException("numberFormat");
        }
        decimalFormat.setParseBigDecimal(true);
        return (BigDecimal)LocaleFormatter.parse(string, decimalFormat);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull Locale locale, @Nullable BigDecimal bigDecimal) {
        return LocaleFormatter.parseBigDecimal(string, NumberFormat.getIntegerInstance(locale), bigDecimal);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull NumberFormat numberFormat, @Nullable BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = null;
        if (numberFormat instanceof DecimalFormat) {
            bigDecimal2 = LocaleFormatter.parseBigDecimal(string, (DecimalFormat)numberFormat);
        } else {
            Number number = LocaleFormatter.parse(string, numberFormat);
            if (number != null) {
                bigDecimal2 = BigDecimal.valueOf(number.doubleValue());
            }
        }
        return bigDecimal2 == null ? bigDecimal : bigDecimal2;
    }
}

