/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale.country;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CountryCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CountryCache.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Set<String> s_aCountries = new HashSet<String>();
    private static final CountryCache s_aInstance;

    private CountryCache() {
    }

    private static void _initialFillCache() {
        for (Locale locale : LocaleCache.getAllLocales()) {
            String string = locale.getCountry();
            if (!StringHelper.hasText(string)) continue;
            CountryCache.addCountry(string);
        }
    }

    @Nonnull
    private static String _getUnifiedCountry(@Nonnull String string) {
        return string.toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static EChange addCountry(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("country");
        }
        if (!string.equals(CountryCache._getUnifiedCountry(string))) {
            throw new IllegalArgumentException("illegal casing of '" + string + "'");
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aCountries.add(string));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public static Locale getCountry(@Nullable Locale locale) {
        return locale == null ? null : CountryCache.getCountry(locale.getCountry());
    }

    @Nullable
    public static Locale getCountry(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        if (string.indexOf(95) >= 0) {
            return CountryCache.getCountry(LocaleCache.getLocale(string));
        }
        String string2 = CountryCache._getUnifiedCountry(string);
        if (!CountryCache.containsCountry(string2)) {
            s_aLogger.warn("Trying to retrieve unsupported country " + string2);
        }
        return LocaleCache.getLocale("", string2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCountries() {
        s_aRWLock.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aCountries);
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static boolean containsCountry(@Nullable Locale locale) {
        return locale == null ? false : CountryCache.containsCountry(locale.getCountry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsCountry(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = CountryCache._getUnifiedCountry(string);
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aCountries.contains(string2);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aCountries.clear();
            CountryCache._initialFillCache();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + CountryCache.class.getName());
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        CountryCache._initialFillCache();
        s_aInstance = new CountryCache();
    }
}

