/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.math;

import com.phloc.commons.CGlobal;
import com.phloc.commons.equals.EqualsUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MathHelper {
    private static final long LONG_HIGH_BITS = Integer.MIN_VALUE;
    private static final MathHelper s_aInstance = new MathHelper();

    private MathHelper() {
    }

    public static double getDividedDouble(int n, int n2) {
        double d = n;
        double d2 = n2;
        return d / d2;
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(int n, int n2) throws ArithmeticException {
        BigDecimal bigDecimal = BigDecimal.valueOf(n);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
        return bigDecimal.divide(bigDecimal2);
    }

    public static int getIntDividedCeil(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.CEILING);
    }

    public static int getIntDividedFloor(int n, int n2) {
        return MathHelper.getIntDivided(n, n2, RoundingMode.FLOOR);
    }

    public static int getIntDivided(int n, int n2, @Nonnull RoundingMode roundingMode) {
        return new BigDecimal(n).divide(new BigDecimal(n2), roundingMode).intValue();
    }

    public static long getLongDividedCeil(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.CEILING);
    }

    public static long getLongDividedFloor(long l, long l2) {
        return MathHelper.getLongDivided(l, l2, RoundingMode.FLOOR);
    }

    public static long getLongDivided(long l, long l2, @Nonnull RoundingMode roundingMode) {
        return new BigDecimal(l).divide(new BigDecimal(l2), roundingMode).longValue();
    }

    public static boolean canConvertLongToInt(long l) {
        return (l & Integer.MIN_VALUE) == 0L || (l & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    @CheckReturnValue
    public static int getLongAsInt(long l, int n) {
        return MathHelper.canConvertLongToInt(l) ? (int)l : n;
    }

    public static int getMaxInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    public static long getMaxLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.max(l2, l3);
        }
        return l2;
    }

    public static double getMaxFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.max(f2, f3);
        }
        return f2;
    }

    public static double getMaxDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMaxBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) <= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMaxBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) <= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    public static int getMinInt(int n, int ... nArray) {
        int n2 = n;
        for (int n3 : nArray) {
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    public static long getMinLong(long l, long ... lArray) {
        long l2 = l;
        for (long l3 : lArray) {
            l2 = Math.min(l2, l3);
        }
        return l2;
    }

    public static double getMinFloat(float f, float ... fArray) {
        float f2 = f;
        for (float f3 : fArray) {
            f2 = Math.min(f2, f3);
        }
        return f2;
    }

    public static double getMinDouble(double d, double ... dArray) {
        double d2 = d;
        for (double d3 : dArray) {
            d2 = Math.min(d2, d3);
        }
        return d2;
    }

    @Nonnull
    public static BigDecimal getMinBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) >= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMinBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) >= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    @Nonnegative
    public static int abs(int n) {
        if (n == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Integer.MIN_VALUE!");
        }
        return Math.abs(n);
    }

    @Nonnegative
    public static long abs(long l) {
        if (l == Long.MIN_VALUE) {
            throw new IllegalArgumentException("There is not absolute value for Long.MIN_VALUE!");
        }
        return Math.abs(l);
    }

    @Nonnegative
    public static float abs(float f) {
        return Math.abs(f);
    }

    @Nonnegative
    public static double abs(double d) {
        return Math.abs(d);
    }

    @Nonnull
    public static BigDecimal abs(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    @Nonnull
    public static BigInteger abs(@Nonnull BigInteger bigInteger) {
        return bigInteger.abs();
    }

    public static boolean isEqualToZero(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isLowerThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) < 0;
    }

    @Deprecated
    public static boolean isLowerOrEqualZero(@Nonnull BigDecimal bigDecimal) {
        return MathHelper.isLowerOrEqualThanZero(bigDecimal);
    }

    public static boolean isLowerOrEqualThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isGreaterThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
    }

    @Deprecated
    public static boolean isGreaterOrEqualZero(@Nonnull BigDecimal bigDecimal) {
        return MathHelper.isGreaterOrEqualThanZero(bigDecimal);
    }

    public static boolean isGreaterOrEqualThanZero(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static boolean isEqualTo100(@Nonnull BigDecimal bigDecimal) {
        return EqualsUtils.equals(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isLowerThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) < 0;
    }

    public static boolean isLowerOrEqualThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) <= 0;
    }

    public static boolean isGreaterThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) > 0;
    }

    public static boolean isGreaterOrEqualThan100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) >= 0;
    }

    public static boolean isEqualToZero(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, BigInteger.ZERO);
    }

    public static boolean isLowerThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0;
    }

    @Deprecated
    public static boolean isLowerOrEqualZero(@Nonnull BigInteger bigInteger) {
        return MathHelper.isLowerOrEqualThanZero(bigInteger);
    }

    public static boolean isLowerOrEqualThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean isGreaterThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) > 0;
    }

    @Deprecated
    public static boolean isGreaterOrEqualZero(@Nonnull BigInteger bigInteger) {
        return MathHelper.isGreaterOrEqualThanZero(bigInteger);
    }

    public static boolean isGreaterOrEqualThanZero(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean isEqualTo100(@Nonnull BigInteger bigInteger) {
        return EqualsUtils.equals(bigInteger, CGlobal.BIGINT_100);
    }

    public static boolean isLowerThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) < 0;
    }

    public static boolean isLowerOrEqualThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) <= 0;
    }

    public static boolean isGreaterThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) > 0;
    }

    public static boolean isGreaterOrEqualThan100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) >= 0;
    }

    public static double hypot(double d, double d2) {
        double d3;
        double d4;
        double d5 = MathHelper.abs(d);
        if (d5 > (d4 = MathHelper.abs(d2))) {
            d3 = d2 / d;
            d3 = d5 * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = d4 * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }
}

