/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.phloc.commons.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageDigestGeneratorHelper {
    private static final MessageDigestGeneratorHelper s_aInstance = new MessageDigestGeneratorHelper();

    private MessageDigestGeneratorHelper() {
    }

    public static long getLongFromDigest(@Nonnull byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; i += 2) {
            l += (long)((byte)(byArray[i] << 8) | byArray[i + 1]);
        }
        return l;
    }

    @Nonnull
    public static String getHexValueFromDigest(@Nonnull byte[] byArray) {
        return StringHelper.getHexEncoded(byArray);
    }

    @Nonnull
    @Deprecated
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull String string, @Nonnull @Nonempty String string2) {
        return MessageDigestGeneratorHelper.getDigest(string, string2, eMessageDigestAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull String string, @Nonnull Charset charset) {
        return MessageDigestGeneratorHelper.getDigest(string, charset, eMessageDigestAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull byte[] byArray) {
        return MessageDigestGeneratorHelper.getDigest(byArray, eMessageDigestAlgorithm);
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return MessageDigestGeneratorHelper.getDigest(byArray, n, n2, eMessageDigestAlgorithm);
    }

    @Nonnull
    @Deprecated
    public static byte[] getDigest(@Nonnull String string, @Nonnull @Nonempty String string2, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray).update(string, string2).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull String string, @Nonnull Charset charset, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray).update(string, charset).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull byte[] byArray, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray).update(byArray).getDigest();
    }

    @Nonnull
    public static byte[] getDigest(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        return new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray).update(byArray, n, n2).getDigest();
    }

    @Nonnull
    public static byte[] getDigestFromInputStream(@Nonnull @WillClose InputStream inputStream, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        NonBlockingMessageDigestGenerator nonBlockingMessageDigestGenerator = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray);
        byte[] byArray = new byte[2048];
        try {
            int n;
            while ((n = inputStream.read(byArray)) > -1) {
                nonBlockingMessageDigestGenerator.update(byArray, 0, n);
            }
            byte[] byArray2 = nonBlockingMessageDigestGenerator.getDigest();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Failed to read from InputStream for hashing!", iOException);
        }
        finally {
            StreamUtils.close(inputStream);
        }
    }
}

