/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.messagedigest.EMessageDigestAlgorithm;
import com.phloc.commons.messagedigest.MessageDigestGeneratorHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MessageDigestValue {
    private final EMessageDigestAlgorithm m_eAlgorithm;
    private final byte[] m_aDigestBytes;

    public MessageDigestValue(@Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm, byte[] byArray) {
        if (eMessageDigestAlgorithm == null) {
            throw new NullPointerException("algorithm");
        }
        if (ArrayHelper.isEmpty(byArray)) {
            throw new IllegalArgumentException("hashBytes");
        }
        this.m_eAlgorithm = eMessageDigestAlgorithm;
        this.m_aDigestBytes = ArrayHelper.getCopy(byArray);
    }

    @Nonnull
    public EMessageDigestAlgorithm getAlgorithm() {
        return this.m_eAlgorithm;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigestBytes() {
        return ArrayHelper.getCopy(this.m_aDigestBytes);
    }

    @Nonnull
    @Nonempty
    public String getDigestString() {
        return StringHelper.getHexEncoded(this.m_aDigestBytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MessageDigestValue)) {
            return false;
        }
        MessageDigestValue messageDigestValue = (MessageDigestValue)object;
        return this.m_eAlgorithm.equals((Object)messageDigestValue.m_eAlgorithm) && EqualsUtils.equals(this.m_aDigestBytes, messageDigestValue.m_aDigestBytes);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eAlgorithm)).append(this.m_aDigestBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("algorithm", this.m_eAlgorithm).append("bytes", Arrays.toString(this.m_aDigestBytes)).toString();
    }

    @Nonnull
    public static MessageDigestValue create(@Nonnull byte[] byArray, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        byte[] byArray2 = MessageDigestGeneratorHelper.getDigest(byArray, eMessageDigestAlgorithm);
        return new MessageDigestValue(eMessageDigestAlgorithm, byArray2);
    }
}

