/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.MicroException;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.microdom.impl.AbstractMicroNodeWithChildren;
import com.phloc.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public static final boolean DEFAULT_STANDALONE = false;
    private boolean m_bIsStandalone = false;

    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType iMicroDocumentType) {
        if (iMicroDocumentType != null) {
            this.appendChild(iMicroDocumentType);
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@Nonnull IMicroNode iMicroNode) {
        return iMicroNode.isDocumentType() || iMicroNode.isProcessingInstruction() || iMicroNode.isComment() || iMicroNode.isElement();
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        List<IMicroNode> list;
        if (!MicroDocument._canBeAppendedToDocumentRoot(abstractMicroNode)) {
            throw new MicroException("Cannot add nodes of type " + abstractMicroNode + " to a document");
        }
        if (abstractMicroNode.isElement() && (list = this.directGetChildren()) != null && !list.isEmpty()) {
            for (IMicroNode iMicroNode : list) {
                if (!iMicroNode.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + iMicroNode + " and wants to add " + abstractMicroNode);
            }
        }
        super.onAppendChild(abstractMicroNode);
    }

    @Override
    public boolean isStandalone() {
        return this.m_bIsStandalone;
    }

    @Override
    public void setStandalone(boolean bl) {
        this.m_bIsStandalone = bl;
    }

    @Override
    @Nullable
    public IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (!iMicroNode.isDocumentType()) continue;
                return (IMicroDocumentType)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (!iMicroNode.isElement()) continue;
                return (IMicroElement)iMicroNode;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public IMicroDocument getClone() {
        MicroDocument microDocument = new MicroDocument();
        microDocument.setStandalone(this.m_bIsStandalone);
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.getChildren()) {
                microDocument.appendChild((IMicroNode)iMicroNode.getClone());
            }
        }
        return microDocument;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroDocument microDocument = (MicroDocument)iMicroNode;
        return this.m_bIsStandalone == microDocument.m_bIsStandalone;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("isStandalone", this.m_bIsStandalone).toString();
    }
}

