/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.annotations.MustImplementEqualsAndHashcode;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class MimeTypeContent {
    private final byte[] m_aContentBytes;
    private final IMimeType m_aMimeType;

    public MimeTypeContent(@Nonnull byte[] byArray, @Nonnull IMimeType iMimeType) {
        if (ArrayHelper.isEmpty(byArray)) {
            throw new IllegalArgumentException("no ContentBytes provided");
        }
        if (iMimeType == null) {
            throw new NullPointerException("mimeType");
        }
        this.m_aContentBytes = ArrayHelper.getCopy(byArray);
        this.m_aMimeType = iMimeType;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getContentBytes() {
        return ArrayHelper.getCopy(this.m_aContentBytes);
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    private static boolean _match(@Nonnull byte[] byArray, int n, @Nonnull byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean matchesBeginning(@Nonnull byte[] byArray) {
        return byArray.length >= this.m_aContentBytes.length && MimeTypeContent._match(byArray, 0, this.m_aContentBytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeContent mimeTypeContent = (MimeTypeContent)object;
        return Arrays.equals(this.m_aContentBytes, mimeTypeContent.m_aContentBytes) && this.m_aMimeType.equals(mimeTypeContent.m_aMimeType);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aContentBytes).append(this.m_aMimeType).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("contentBytes", Arrays.toString(this.m_aContentBytes)).append("mimeType", this.m_aMimeType).toString();
    }
}

