/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mime;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.MustBeLocked;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.microdom.reader.XMLMapHandler;
import com.phloc.commons.mime.CMimeType;
import com.phloc.commons.mime.IMimeType;
import com.phloc.commons.mime.MimeType;
import com.phloc.commons.mime.MimeTypeContent;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.state.EChange;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MimeTypeDeterminator {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeTypeDeterminator.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, String> s_aFileExtMap = new HashMap<String, String>();
    private static final Set<MimeTypeContent> s_aContents = new HashSet<MimeTypeContent>();
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_XML = new byte[]{60, 63, 120, 109, 108};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final MimeTypeDeterminator s_aInstance;

    @MustBeLocked(value=MustBeLocked.ELockType.WRITE)
    private static void _registerDefaultMimeTypeContents() {
        s_aContents.add(new MimeTypeContent(MIME_ID_GIF87A, CMimeType.IMAGE_GIF));
        s_aContents.add(new MimeTypeContent(MIME_ID_GIF89A, CMimeType.IMAGE_GIF));
        s_aContents.add(new MimeTypeContent(MIME_ID_JPG, CMimeType.IMAGE_JPG));
        s_aContents.add(new MimeTypeContent(MIME_ID_PNG, CMimeType.IMAGE_PNG));
        s_aContents.add(new MimeTypeContent(MIME_ID_TIFF_MOTOROLLA, CMimeType.IMAGE_TIFF));
        s_aContents.add(new MimeTypeContent(MIME_ID_TIFF_INTEL, CMimeType.IMAGE_TIFF));
        s_aContents.add(new MimeTypeContent(MIME_ID_PSD, CMimeType.IMAGE_PSD));
        s_aContents.add(new MimeTypeContent(MIME_ID_XML, CMimeType.TEXT_XML));
        s_aContents.add(new MimeTypeContent(MIME_ID_PDF, CMimeType.APPLICATION_PDF));
    }

    private MimeTypeDeterminator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange registerMimeTypeContent(@Nonnull MimeTypeContent mimeTypeContent) {
        if (mimeTypeContent == null) {
            throw new NullPointerException("MimeTypeContent");
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aContents.add(mimeTypeContent));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange unregisterMimeTypeContent(@Nullable MimeTypeContent mimeTypeContent) {
        if (mimeTypeContent == null) {
            return EChange.UNCHANGED;
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aContents.remove(mimeTypeContent));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @Deprecated
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull @Nonempty String string2) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, string2));
    }

    @Nonnull
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset) {
        return MimeTypeDeterminator.getMimeTypeFromString(string, charset, CMimeType.APPLICATION_OCTET_STREAM);
    }

    @Nullable
    public static IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset, @Nullable IMimeType iMimeType) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, charset), iMimeType);
    }

    @Nonnull
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray) {
        return MimeTypeDeterminator.getMimeTypeFromBytes(byArray, CMimeType.APPLICATION_OCTET_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray, @Nullable IMimeType iMimeType) {
        if (byArray != null) {
            s_aRWLock.readLock().lock();
            try {
                for (MimeTypeContent mimeTypeContent : s_aContents) {
                    if (!mimeTypeContent.matchesBeginning(byArray)) continue;
                    IMimeType iMimeType2 = mimeTypeContent.getMimeType();
                    return iMimeType2;
                }
            }
            finally {
                s_aRWLock.readLock().unlock();
            }
        }
        return iMimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static List<MimeTypeContent> getAllMimeTypeContents() {
        s_aRWLock.readLock().lock();
        try {
            List<MimeTypeContent> list = ContainerHelper.newList(s_aContents);
            return list;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public static String getMimeTypeFromFilename(@Nonnull String string) {
        String string2 = FilenameHelper.getExtension(string);
        return MimeTypeDeterminator.getMimeTypeFromExtension(string2);
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromFilename(@Nonnull String string) {
        String string2 = MimeTypeDeterminator.getMimeTypeFromFilename(string);
        return MimeType.parseFromStringWithoutEncoding(string2);
    }

    @Nullable
    public static String getMimeTypeFromExtension(@Nonnull String string) {
        String string2 = s_aFileExtMap.get(string);
        if (string2 == null) {
            string2 = s_aFileExtMap.get(string.toLowerCase(Locale.US));
        }
        return string2;
    }

    @Nullable
    public static IMimeType getMimeTypeObjectFromExtension(@Nonnull String string) {
        String string2 = MimeTypeDeterminator.getMimeTypeFromExtension(string);
        return MimeType.parseFromStringWithoutEncoding(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Collection<String> getAllKnownMimeTypes() {
        return ContainerHelper.newList(s_aFileExtMap.values());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getAllKnownMimeTypeFilenameMappings() {
        return ContainerHelper.newMap(s_aFileExtMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aContents.clear();
            MimeTypeDeterminator._registerDefaultMimeTypeContents();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + MimeTypeDeterminator.class.getName());
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        if (XMLMapHandler.readMap(new ClassPathResource("codelists/fileext-mimetype-mapping.xml"), s_aFileExtMap).isFailure()) {
            throw new InitializationException("Failed to init file extension to mimetype mapping file");
        }
        if (GlobalDebug.isDebugMode()) {
            for (Map.Entry<String, String> entry : s_aFileExtMap.entrySet()) {
                String string = entry.getKey();
                if (!RegExHelper.stringMatchesPattern("(|[a-zA-Z0-9]+(\\.[a-z0-9]+)*)", string)) {
                    throw new InitializationException("MIME file extension '" + string + "' is invalid!");
                }
                if (!entry.getValue().contains(" ")) continue;
                throw new InitializationException("MIME type '" + entry.getValue() + "' is invalid!");
            }
        }
        MimeTypeDeterminator._registerDefaultMimeTypeContents();
        s_aInstance = new MimeTypeDeterminator();
    }
}

