/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.compare.CompareUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutable;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableBoolean
implements IMutable<MutableBoolean> {
    public static final boolean DEFAULT_VALUE = false;
    private boolean m_bValue;

    public MutableBoolean() {
        this(false);
    }

    public MutableBoolean(@Nonnull Boolean bl) {
        this((boolean)bl);
    }

    public MutableBoolean(boolean bl) {
        this.m_bValue = bl;
    }

    public boolean booleanValue() {
        return this.m_bValue;
    }

    @Nonnull
    public Boolean getAsBoolean() {
        return this.m_bValue;
    }

    @Nonnull
    public EChange set(boolean bl) {
        if (this.m_bValue == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bValue = bl;
        return EChange.CHANGED;
    }

    @Override
    public int compareTo(@Nonnull MutableBoolean mutableBoolean) {
        return CompareUtils.compareFalseBeforeTrue(this.m_bValue, mutableBoolean.m_bValue);
    }

    @Override
    @Nonnull
    public MutableBoolean getClone() {
        return new MutableBoolean(this.m_bValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableBoolean)) {
            return false;
        }
        MutableBoolean mutableBoolean = (MutableBoolean)object;
        return this.m_bValue == mutableBoolean.m_bValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_bValue).toString();
    }
}

