/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.regex;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.regex.RegExPool;
import com.phloc.commons.string.StringHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RegExHelper {
    private static final RegExHelper s_aInstance = new RegExHelper();

    private RegExHelper() {
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence charSequence, @Nonnull @RegEx String string) {
        if (charSequence == null) {
            return new String[0];
        }
        return RegExPool.getPattern(string).split(charSequence);
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence charSequence, @Nonnull @RegEx String string, @Nonnegative int n) {
        if (string == null) {
            throw new IllegalArgumentException("regexp");
        }
        if (charSequence == null) {
            return new String[0];
        }
        return RegExPool.getPattern(string).split(charSequence, n);
    }

    @Nonnull
    public static List<String> getSplitToList(@Nullable CharSequence charSequence, @Nonnull @RegEx String string) {
        return ContainerHelper.newList(RegExHelper.getSplitToArray(charSequence, string));
    }

    @Nonnull
    public static List<String> getSplitToList(@Nullable CharSequence charSequence, @Nonnull @RegEx String string, @Nonnegative int n) {
        return ContainerHelper.newList(RegExHelper.getSplitToArray(charSequence, string, n));
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String string, @Nonnull String string2) {
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        return RegExPool.getPattern(string).matcher(string2);
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2) {
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        return RegExPool.getPattern(string, n).matcher(string2);
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String string, @Nonnull String string2) {
        return RegExHelper.getMatcher(string, string2).matches();
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2) {
        return RegExHelper.getMatcher(string, n, string2).matches();
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String string, @Nonnull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, string2).replaceAll(StringHelper.getNotNull(string3));
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String string, @Nonnegative int n, @Nonnull String string2, @Nullable String string3) {
        return RegExHelper.getMatcher(string, n, string2).replaceAll(StringHelper.getNotNull(string3));
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string) {
        return RegExHelper.getAsIdentifier(string, "_");
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string2 = Character.toString(c);
        String string3 = RegExHelper.stringReplacePattern("\\W", string, Pattern.quote(string2));
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            return string2 + string3;
        }
        return string3;
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String string, @Nonnull String string2) {
        if (string2 == null) {
            throw new NullPointerException("replacement");
        }
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string3 = RegExHelper.stringReplacePattern("\\W", string, string2);
        if (string3.length() == 0) {
            return string2;
        }
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            return string2 + string3;
        }
        return string3;
    }

    public static boolean isValidPattern(@Nonnull @RegEx String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    @Nullable
    public static String[] getAllMatchingGroupValues(@Nonnull @RegEx String string, @Nonnull String string2) {
        Matcher matcher = RegExHelper.getMatcher(string, string2);
        if (!matcher.find()) {
            return null;
        }
        int n = matcher.groupCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = matcher.group(i + 1);
        }
        return stringArray;
    }
}

