/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.stats.IStatisticsHandlerKeyedNumeric;
import com.phloc.commons.string.ToStringGenerator;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class AbstractStatisticsHandlerKeyedNumeric
implements IStatisticsHandlerKeyedNumeric {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);
    private final Map<String, Value> m_aMap = new HashMap<String, Value>();

    AbstractStatisticsHandlerKeyedNumeric() {
    }

    @Override
    @Nonnegative
    public final int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<String> getAllKeys() {
        this.m_aRWLock.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(this.m_aMap.keySet());
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addValue(@Nullable String string, long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aRWLock.writeLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            if (value == null) {
                this.m_aMap.put(string, new Value(l));
            } else {
                value.add(l);
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public final int getInvocationCount(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            int n = value == null ? -1 : value.getInvocationCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final BigInteger getSum(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            BigInteger bigInteger = value == null ? null : value.getSum();
            return bigInteger;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public final long getMin(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            long l = value == null ? -1L : value.getMin();
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public final long getAverage(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            long l = value == null ? -1L : value.getAverage();
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public long getMax(@Nullable String string) {
        this.m_aRWLock.readLock().lock();
        try {
            Value value = this.m_aMap.get(string);
            long l = value == null ? -1L : value.getMax();
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "invocations=" + this.getInvocationCount() + ";map=" + this.m_aMap.entrySet();
    }

    private static final class Value {
        private int m_nInvocationCount = 1;
        private long m_nMin;
        private long m_nMax;
        private BigInteger m_aSum;

        public Value(long l) {
            this.m_nMin = l;
            this.m_nMax = l;
            this.m_aSum = BigInteger.valueOf(l);
        }

        public void add(long l) {
            ++this.m_nInvocationCount;
            if (l < this.m_nMin) {
                this.m_nMin = l;
            }
            if (l > this.m_nMax) {
                this.m_nMax = l;
            }
            this.m_aSum = this.m_aSum.add(BigInteger.valueOf(l));
        }

        @Nonnegative
        public int getInvocationCount() {
            return this.m_nInvocationCount;
        }

        @CheckForSigned
        public long getMin() {
            return this.m_nMin;
        }

        @CheckForSigned
        public long getMax() {
            return this.m_nMax;
        }

        @Nonnull
        public BigInteger getSum() {
            return this.m_aSum;
        }

        @CheckForSigned
        public long getAverage() {
            return this.m_aSum.divide(BigInteger.valueOf(this.m_nInvocationCount)).longValue();
        }

        public String toString() {
            return new ToStringGenerator(null).append("invocations", this.m_nInvocationCount).append("min", this.m_nMin).append("max", this.m_nMax).append("sum", this.m_aSum).toString();
        }
    }
}

