/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats.visit;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.stats.IStatisticsHandler;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.stats.visit.IStatisticsVisitor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StatisticsWalker {
    private static final StatisticsWalker s_aInstance = new StatisticsWalker();

    private StatisticsWalker() {
    }

    public static void walkStatistics(@Nonnull IStatisticsVisitor iStatisticsVisitor) {
        IStatisticsHandler iStatisticsHandler;
        if (iStatisticsVisitor == null) {
            throw new NullPointerException("visitor");
        }
        List<String> list = ContainerHelper.getSorted(StatisticsManager.getAllCacheHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getCacheHandler(string);
            iStatisticsVisitor.onCache(string, (IStatisticsHandlerCache)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllTimerHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getTimerHandler(string);
            iStatisticsVisitor.onTimer(string, (IStatisticsHandlerTimer)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllKeyedTimerHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedTimerHandler(string);
            iStatisticsVisitor.onKeyedTimer(string, (IStatisticsHandlerKeyedTimer)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllSizeHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getSizeHandler(string);
            iStatisticsVisitor.onSize(string, (IStatisticsHandlerSize)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllKeyedSizeHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedSizeHandler(string);
            iStatisticsVisitor.onKeyedSize(string, (IStatisticsHandlerKeyedSize)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllCounterHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getCounterHandler(string);
            iStatisticsVisitor.onCounter(string, (IStatisticsHandlerCounter)iStatisticsHandler);
        }
        list = ContainerHelper.getSorted(StatisticsManager.getAllKeyedCounterHandler());
        for (String string : list) {
            iStatisticsHandler = StatisticsManager.getKeyedCounterHandler(string);
            iStatisticsVisitor.onKeyedCounter(string, (IStatisticsHandlerKeyedCounter)iStatisticsHandler);
        }
    }
}

