/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.walk;

import com.phloc.commons.hierarchy.IHierarchyWalkerCallback;
import com.phloc.commons.parent.IChildrenProvider;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildren;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.IBasicTreeItem;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeWalker {
    private static final TreeWalker s_aInstance = new TreeWalker();

    private TreeWalker() {
    }

    private static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void _walkTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        iHierarchyWalkerCallback.onItemBeforeChildren(ITEMTYPE);
        if (iChildrenProvider.hasChildren(ITEMTYPE)) {
            for (IBasicTreeItem iBasicTreeItem : iChildrenProvider.getChildren(ITEMTYPE)) {
                iHierarchyWalkerCallback.onLevelDown();
                TreeWalker._walkTree(iBasicTreeItem, iChildrenProvider, iHierarchyWalkerCallback);
                iHierarchyWalkerCallback.onLevelUp();
            }
        }
        iHierarchyWalkerCallback.onItemAfterChildren(ITEMTYPE);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkTree(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkTree(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        if (iBasicTree == null) {
            throw new NullPointerException("tree");
        }
        TreeWalker.walkSubTree(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyWalkerCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        TreeWalker.walkSubTree(ITEMTYPE, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void walkSubTree(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull IChildrenProvider<ITEMTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super ITEMTYPE> iHierarchyWalkerCallback) {
        if (ITEMTYPE == null) {
            throw new NullPointerException("treeItem");
        }
        if (iChildrenProvider == null) {
            throw new NullPointerException("childrenProvider");
        }
        if (iHierarchyWalkerCallback == null) {
            throw new NullPointerException("callback");
        }
        iHierarchyWalkerCallback.begin();
        try {
            if (iChildrenProvider.hasChildren(ITEMTYPE)) {
                for (IBasicTreeItem iBasicTreeItem : iChildrenProvider.getChildren(ITEMTYPE)) {
                    TreeWalker._walkTree(iBasicTreeItem, iChildrenProvider, iHierarchyWalkerCallback);
                }
            }
        }
        finally {
            iHierarchyWalkerCallback.end();
        }
    }
}

