/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.xml;

import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.convert.UnidirectionalConverterIdentity;
import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.id.ComparatorHasIDString;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.microdom.utils.ChildrenProviderElementWithName;
import com.phloc.commons.microdom.utils.MicroWalker;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildrenSorting;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.IBasicTreeItem;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import com.phloc.commons.tree.utils.xml.IConverterMicroNodeToTreeItem;
import com.phloc.commons.tree.utils.xml.IConverterTreeItemToMicroNode;
import com.phloc.commons.tree.withid.BasicTreeWithID;
import com.phloc.commons.tree.withid.DefaultTreeWithID;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeXMLConverter {
    private static final String ELEMENT_ROOT = "root";
    private static final String ELEMENT_ITEM = "item";
    private static final String ATTR_ID = "id";
    private static final String ELEMENT_DATA = "data";
    private static final TreeXMLConverter s_aInstance = new TreeXMLConverter();

    private TreeXMLConverter() {
    }

    @Nonnull
    public static <DATATYPE, ITEMTYPE extends ITreeItemWithID<String, DATATYPE, ITEMTYPE>> IMicroElement getTreeWithStringIDAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        return TreeXMLConverter.getTreeWithIDAsXML(iBasicTree, new ComparatorHasIDString(), UnidirectionalConverterIdentity.<String>create(), iConverterTreeItemToMicroNode);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> IMicroElement getTreeWithIDAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super ITEMTYPE> comparator, final @Nonnull IUnidirectionalConverter<KEYTYPE, String> iUnidirectionalConverter, final @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        MicroElement microElement = new MicroElement(ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> nonBlockingStack = new NonBlockingStack<MicroElement>();
        nonBlockingStack.push(microElement);
        TreeWalker.walkTree(iBasicTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(comparator), new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).appendElement(TreeXMLConverter.ELEMENT_ITEM);
                    iMicroElement.setAttribute(TreeXMLConverter.ATTR_ID, (String)iUnidirectionalConverter.convert(ITEMTYPE.getID()));
                    IMicroElement iMicroElement2 = iMicroElement.appendElement(TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push(iMicroElement);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
            }
        });
        return microElement;
    }

    @Nonnull
    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> IMicroElement getTreeAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super ITEMTYPE> comparator, final @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        MicroElement microElement = new MicroElement(ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> nonBlockingStack = new NonBlockingStack<MicroElement>();
        nonBlockingStack.push(microElement);
        TreeWalker.walkTree(iBasicTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(comparator), new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).appendElement(TreeXMLConverter.ELEMENT_ITEM);
                    IMicroElement iMicroElement2 = iMicroElement.appendElement(TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push(iMicroElement);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
            }
        });
        return microElement;
    }

    private static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void _getXMLAsTreeWithID(@Nonnull IMicroElement iMicroElement, final @Nonnull IUnidirectionalConverter<String, KEYTYPE> iUnidirectionalConverter, final @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem, @Nonnull BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> basicTreeWithID) {
        final NonBlockingStack<IBasicTreeItem> nonBlockingStack = new NonBlockingStack<IBasicTreeItem>();
        nonBlockingStack.push(basicTreeWithID.getRootItem());
        MicroWalker.walkNode(iMicroElement, new ChildrenProviderElementWithName(ELEMENT_ITEM), new DefaultHierarchyWalkerCallback<IMicroElement>(){

            @Override
            public void onItemBeforeChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    Object DSTTYPE = iUnidirectionalConverter.convert(iMicroElement.getAttribute(TreeXMLConverter.ATTR_ID));
                    IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(TreeXMLConverter.ELEMENT_DATA);
                    Object DATATYPE = iConverterMicroNodeToTreeItem.getAsDataValue(iMicroElement2);
                    Object ITEMTYPE = ((ITreeItemWithID)nonBlockingStack.peek()).createChildItem(DSTTYPE, DATATYPE);
                    nonBlockingStack.push(ITEMTYPE);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    nonBlockingStack.pop();
                }
            }
        });
    }

    @Nonnull
    public static <DATATYPE> DefaultTreeWithGlobalUniqueID<String, DATATYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroDocument iMicroDocument, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueStringID(iMicroDocument.getDocumentElement(), iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <DATATYPE> DefaultTreeWithGlobalUniqueID<String, DATATYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroElement iMicroElement, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(iMicroElement, UnidirectionalConverterIdentity.create(), iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, DATATYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroDocument iMicroDocument, @Nonnull IUnidirectionalConverter<String, KEYTYPE> iUnidirectionalConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(iMicroDocument.getDocumentElement(), iUnidirectionalConverter, iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, DATATYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroElement iMicroElement, @Nonnull IUnidirectionalConverter<String, KEYTYPE> iUnidirectionalConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithGlobalUniqueID defaultTreeWithGlobalUniqueID = new DefaultTreeWithGlobalUniqueID();
        TreeXMLConverter._getXMLAsTreeWithID(iMicroElement, iUnidirectionalConverter, iConverterMicroNodeToTreeItem, defaultTreeWithGlobalUniqueID);
        return defaultTreeWithGlobalUniqueID;
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithID<KEYTYPE, DATATYPE> getXMLAsTreeWithID(@Nonnull IMicroDocument iMicroDocument, @Nonnull IUnidirectionalConverter<String, KEYTYPE> iUnidirectionalConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithID(iMicroDocument.getDocumentElement(), iUnidirectionalConverter, iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithID<KEYTYPE, DATATYPE> getXMLAsTreeWithID(@Nonnull IMicroElement iMicroElement, @Nonnull IUnidirectionalConverter<String, KEYTYPE> iUnidirectionalConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        TreeXMLConverter._getXMLAsTreeWithID(iMicroElement, iUnidirectionalConverter, iConverterMicroNodeToTreeItem, defaultTreeWithID);
        return defaultTreeWithID;
    }
}

