/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert;

import com.phloc.commons.annotations.NoTranslationRequired;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.text.impl.TextFormatter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TypeConverterException
extends RuntimeException {
    private final Class<?> m_aSrcClass;
    private final Class<?> m_aDstClass;
    private final EReason m_eReason;

    public TypeConverterException(@Nonnull Class<?> clazz, @Nonnull EReason eReason) {
        super(eReason.getMessage(clazz));
        this.m_aSrcClass = null;
        this.m_aDstClass = clazz;
        this.m_eReason = eReason;
    }

    public TypeConverterException(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull EReason eReason) {
        this(clazz, clazz2, eReason, null);
    }

    public TypeConverterException(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2, @Nonnull EReason eReason, @Nullable Throwable throwable) {
        super(eReason.getMessage(clazz, clazz2), throwable);
        this.m_aSrcClass = clazz;
        this.m_aDstClass = clazz2;
        this.m_eReason = eReason;
    }

    @Nullable
    public Class<?> getSrcClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public Class<?> getDstClass() {
        return this.m_aDstClass;
    }

    @Nonnull
    public EReason getReason() {
        return this.m_eReason;
    }

    @NoTranslationRequired(value="because whenever an exception is thrown, no locale is present!")
    public static enum EReason {
        CONVERSION_FAILED(2, "Conversion from type {0} to type {1} failed!"),
        NO_CONVERTER_FOUND(2, "No converter found to convert an object of type {0} to type {1}"),
        NULL_SOURCE_NOT_ALLOWED(1, "A null source object cannot be converted to type {0}");

        private final int m_nParamCount;
        private final String m_sMsg;

        private EReason(int n2, String string2) {
            this.m_nParamCount = n2;
            this.m_sMsg = string2;
        }

        @Nonnull
        @Nonempty
        public String getMessage(@Nonnull Class<?> clazz) {
            if (this.m_nParamCount != 1) {
                throw new IllegalStateException("Message does not expect 1 parameter!");
            }
            return TextFormatter.getFormattedText(this.m_sMsg, clazz.getName());
        }

        @Nonnull
        @Nonempty
        public String getMessage(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
            if (this.m_nParamCount != 2) {
                throw new IllegalStateException("Message does not expect 2 parameters!");
            }
            return TextFormatter.getFormattedText(this.m_sMsg, clazz.getName(), clazz2.getName());
        }
    }
}

