/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import com.phloc.commons.url.URLUtils;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSimpleURL
implements ISimpleURL {
    private final String m_sPath;
    protected Map<String, String> m_aParams;
    protected String m_sAnchor;

    public AbstractSimpleURL() {
        this("?", null, null);
    }

    public AbstractSimpleURL(@Nonnull String string) {
        this(URLUtils.getAsURLData(string));
    }

    public AbstractSimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string);
        if (ContainerHelper.isNotEmpty(map)) {
            if (this.m_aParams == null) {
                this.m_aParams = new LinkedHashMap<String, String>();
            }
            this.m_aParams.putAll(map);
        }
    }

    public AbstractSimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, map);
        if (string2 != null) {
            this.m_sAnchor = string2;
        }
    }

    public AbstractSimpleURL(@Nonnull IURLData iURLData) {
        if (iURLData == null) {
            throw new NullPointerException("URL");
        }
        this.m_sPath = iURLData.getPath();
        if (iURLData.directGetParams() != null) {
            this.m_aParams = new LinkedHashMap<String, String>(iURLData.directGetParams());
        }
        this.m_sAnchor = iURLData.getAnchor();
    }

    @Override
    @Nullable
    public final IURLProtocol getProtocol() {
        return URLProtocolRegistry.getProtocol(this.m_sPath);
    }

    @Override
    public final boolean hasKnownProtocol() {
        return URLProtocolRegistry.hasKnownProtocol(this.m_sPath);
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    public final boolean hasParams() {
        return ContainerHelper.isNotEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public final int getParamCount() {
        return ContainerHelper.getSize(this.m_aParams);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(reason="design")
    public final Map<String, String> directGetParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Map<String, String> getAllParams() {
        return ContainerHelper.newOrderedMap(this.m_aParams);
    }

    @Override
    public final boolean hasAnchor() {
        return StringHelper.hasText(this.m_sAnchor);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Override
    @Nullable
    public final String getParam(@Nullable String string) {
        return this.m_aParams == null ? null : this.m_aParams.get(string);
    }

    @Override
    @Nonnull
    public final String getAsString() {
        return URLUtils.getURLString((IURLData)this, (Charset)null);
    }

    @Override
    @Nonnull
    public final String getAsStringWithEncodedParameters() {
        return this.getAsStringWithEncodedParameters(URLUtils.CHARSET_URL_OBJ);
    }

    @Override
    @Nonnull
    @Deprecated
    public final String getAsStringWithEncodedParameters(@Nonnull String string) {
        if (string == null) {
            throw new NullPointerException("parameterCharset");
        }
        return URLUtils.getURLString((IURLData)this, string);
    }

    @Override
    @Nonnull
    public final String getAsStringWithEncodedParameters(@Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("parameterCharset");
        }
        return URLUtils.getURLString((IURLData)this, charset);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractSimpleURL abstractSimpleURL = (AbstractSimpleURL)object;
        return this.m_sPath.equals(abstractSimpleURL.m_sPath) && EqualsUtils.equals(this.m_aParams, abstractSimpleURL.m_aParams) && EqualsUtils.equals(this.m_sAnchor, abstractSimpleURL.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Map)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

