/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.encode.IDecoder;
import com.phloc.commons.encode.IEncoder;
import com.phloc.commons.encode.IdentityDecoder;
import com.phloc.commons.encode.IdentityEncoder;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.microdom.reader.XMLMapHandler;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLData;
import com.phloc.commons.url.URLProtocolRegistry;
import com.phloc.commons.url.encode.URLParameterEncoder;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class URLUtils {
    public static final String CHARSET_URL = "UTF-8";
    public static final Charset CHARSET_URL_OBJ = CCharset.CHARSET_UTF_8_OBJ;
    public static final char QUESTIONMARK = '?';
    public static final char AMPERSAND = '&';
    public static final char EQUALS = '=';
    public static final char HASH = '#';
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLUtils.class);
    private static final String QUESTIONMARK_STR = Character.toString('?');
    private static final char[] CLEANURL_OLD;
    private static final char[][] CLEANURL_NEW;

    private URLUtils() {
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string) {
        return URLUtils.urlDecode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return URLUtils.urlDecode(string, charset.name());
    }

    @Nonnull
    public static String urlDecode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLDecoder.decode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLDecoder.decode(string);
        }
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string) {
        return URLUtils.urlEncode(string, CHARSET_URL);
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return URLUtils.urlEncode(string, charset.name());
    }

    @Nonnull
    public static String urlEncode(@Nonnull String string, @Nonnull @Nonempty String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return URLEncoder.encode(string);
        }
    }

    @Nullable
    public static String getCleanURLPartWithoutUmlauts(@Nullable String string) {
        return new String(StringHelper.replaceMultiple(string, CLEANURL_OLD, CLEANURL_NEW));
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string) {
        return URLUtils.getAsURLData(string, IdentityDecoder.<String>create());
    }

    @Nonnull
    public static IURLData getAsURLData(@Nonnull String string, @Nonnull IDecoder<String> iDecoder) {
        String string2;
        String string3;
        if (string == null) {
            throw new NullPointerException("href");
        }
        if (iDecoder == null) {
            throw new NullPointerException("parameterDecoder");
        }
        IURLProtocol iURLProtocol = URLProtocolRegistry.getProtocol(string);
        if (iURLProtocol != null && !iURLProtocol.allowsForQueryParameters()) {
            return new URLData(string, null, null);
        }
        if (GlobalDebug.isDebugMode() && iURLProtocol != null) {
            try {
                new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                s_aLogger.warn("java.net.URL claims URL '" + string + "' to be invalid: " + malformedURLException.getMessage());
            }
        }
        Map<String, String> map = null;
        String string4 = string;
        int n = string4.indexOf(35);
        if (n >= 0) {
            string3 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        } else {
            string3 = null;
        }
        int n2 = string4.indexOf(63);
        if (n2 >= 0) {
            String string5 = string4.substring(n2 + 1);
            if (StringHelper.hasText(string5)) {
                map = URLUtils._getQueryStringAsMap(string5, iDecoder);
            }
            string2 = string4.substring(0, n2);
        } else {
            string2 = string4;
        }
        return new URLData(string2, map, string3);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static Map<String, String> _getQueryStringAsMap(@Nullable String string, @Nonnull IDecoder<String> iDecoder) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (StringHelper.hasText(string)) {
            for (String string2 : StringHelper.getExploded('&', string)) {
                String string3;
                if (string2.length() <= 0) continue;
                List<String> list = StringHelper.getExploded('=', string2, 2);
                String string4 = list.get(0);
                if (StringHelper.hasNoText(string4)) {
                    throw new IllegalArgumentException("parameter name may not be empty!");
                }
                String string5 = string3 = list.size() == 2 ? list.get(1) : "";
                if (string3 == null) {
                    throw new NullPointerException("parameter value may not be null");
                }
                linkedHashMap.put(iDecoder.decode(string4), iDecoder.decode(string3));
            }
        }
        return linkedHashMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getQueryStringAsMap(@Nullable String string) {
        return URLUtils._getQueryStringAsMap(string, IdentityDecoder.<String>create());
    }

    @Nonnull
    @Deprecated
    public static String getURLString(@Nonnull IURLData iURLData, @Nullable String string) {
        return URLUtils.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), string);
    }

    @Nonnull
    public static String getURLString(@Nonnull IURLData iURLData, @Nullable Charset charset) {
        return URLUtils.getURLString(iURLData.getPath(), iURLData.getAllParams(), iURLData.getAnchor(), charset);
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nonnull IEncoder<String> iEncoder) {
        if (string != null) {
            if (string.indexOf(63) >= 0) {
                throw new IllegalArgumentException("Path contains a '?': " + string);
            }
            if (string.indexOf(35) >= 0) {
                throw new IllegalArgumentException("Path contains a '#': " + string);
            }
        }
        if (iEncoder == null) {
            throw new NullPointerException("parameterEncoder");
        }
        boolean bl = map != null && !map.isEmpty();
        boolean bl2 = StringHelper.hasText(string2);
        if (!bl && !bl2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl) {
            if (stringBuilder.indexOf(QUESTIONMARK_STR) >= 0) {
                char c = StringHelper.getLastChar(stringBuilder);
                if (c != '?' && c != '&') {
                    stringBuilder.append('&');
                }
            } else {
                stringBuilder.append('?');
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string3 = entry.getKey();
                String string4 = entry.getValue();
                stringBuilder.append(iEncoder.encode(string3));
                if (StringHelper.hasText(string4)) {
                    stringBuilder.append('=').append(iEncoder.encode(string4));
                }
                stringBuilder.append('&');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (bl2) {
            stringBuilder.append('#').append(string2);
        }
        return stringBuilder.toString();
    }

    @Nullable
    @Deprecated
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable String string3) {
        return URLUtils.getURLString(string, map, string2, string3 == null ? null : CharsetManager.getCharsetFromName(string3));
    }

    @Nullable
    public static String getURLString(@Nullable String string, @Nullable Map<String, String> map, @Nullable String string2, @Nullable Charset charset) {
        IEncoder iEncoder = charset == null ? IdentityEncoder.create() : new URLParameterEncoder(charset);
        return URLUtils.getURLString(string, map, string2, iEncoder);
    }

    @Nullable
    public static URL getAsURL(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URL getAsURL(@Nullable URI uRI) {
        if (uRI != null) {
            try {
                return uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static URI getAsURI(@Nullable URL uRL) {
        if (uRL != null) {
            try {
                return uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        XMLMapHandler.readMap(new ClassPathResource("codelists/cleanurl-data.xml"), hashMap);
        CLEANURL_OLD = new char[hashMap.size()];
        CLEANURL_NEW = new char[hashMap.size()][];
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.length() != 1) {
                throw new IllegalStateException("Clean URL source character has an invalid length: " + string.length());
            }
            URLUtils.CLEANURL_OLD[n] = string.charAt(0);
            URLUtils.CLEANURL_NEW[n] = ((String)entry.getValue()).toCharArray();
            ++n;
        }
    }
}

