/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EXMLIncorrectCharacterHandling {
    THROW_EXCEPTION(true, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) throws IllegalArgumentException {
            throw new IllegalArgumentException("XML content contains invalid character data: '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
        }
    }
    ,
    WRITE_TO_FILE_NO_LOG(false, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
        }
    }
    ,
    WRITE_TO_FILE_LOG_WARNING(false, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
            s_aLogger.warn("XML content contains invalid character data (no replacement): '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
        }
    }
    ,
    DO_NOT_WRITE_NO_LOG(true, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
        }
    }
    ,
    DO_NOT_WRITE_LOG_WARNING(true, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String string, @Nonnull Set<Character> set) {
            s_aLogger.warn("XML content contains invalid character data (will replace): '" + string + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(set));
        }
    };

    public static final EXMLIncorrectCharacterHandling DEFAULT;
    private static final Logger s_aLogger;
    private final boolean m_bIsTestRequired;
    private final boolean m_bReplaceWithNothing;

    private EXMLIncorrectCharacterHandling(boolean bl, boolean bl2) {
        this.m_bIsTestRequired = bl;
        this.m_bReplaceWithNothing = bl2;
    }

    public boolean isTestRequired() {
        return this.m_bIsTestRequired;
    }

    public boolean isReplaceWithNothing() {
        return this.m_bReplaceWithNothing;
    }

    @Nonnull
    private static String _getAsString(@Nonnull Set<Character> set) {
        if (ContainerHelper.isEmpty(set)) {
            return "NONE";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Character c : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            char c2 = c.charValue();
            stringBuilder.append("0x").append(Integer.toHexString(c2));
        }
        return stringBuilder.toString();
    }

    public abstract void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String var1, @Nonnull Set<Character> var2);

    static {
        DEFAULT = WRITE_TO_FILE_NO_LOG;
        s_aLogger = LoggerFactory.getLogger(EXMLIncorrectCharacterHandling.class);
    }
}

