/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithNamespace
implements IFilter<Element> {
    private final String m_sNamespaceURI;

    public FilterElementWithNamespace(@Nullable String string) {
        this.m_sNamespaceURI = string;
    }

    @Override
    public boolean matchesFilter(@Nonnull Element element) {
        return XMLHelper.hasNamespaceURI(element, this.m_sNamespaceURI);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterElementWithNamespace)) {
            return false;
        }
        FilterElementWithNamespace filterElementWithNamespace = (FilterElementWithNamespace)object;
        return EqualsUtils.equals(this.m_sNamespaceURI, filterElementWithNamespace.m_sNamespaceURI);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sNamespaceURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

