/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecursiveChildNodeIterator
implements IIterableIterator<Node> {
    private final Iterator<Node> m_aIter;

    public RecursiveChildNodeIterator(@Nonnull Node node) {
        if (node == null) {
            throw new NullPointerException("parent");
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        RecursiveChildNodeIterator._fillListPrefix(node, arrayList);
        this.m_aIter = arrayList.iterator();
    }

    private static void _fillListPrefix(@Nonnull Node node, @Nonnull List<Node> list) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                list.add(node2);
                RecursiveChildNodeIterator._fillListPrefix(node2, list);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Override
    public Node next() {
        return this.m_aIter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<Node> iterator() {
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }
}

