/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.ls;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.URLUtils;
import com.phloc.commons.xml.ls.ResourceLSInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SimpleLSResourceResolver
implements LSResourceResolver {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SimpleLSResourceResolver.class);
    private final LSResourceResolver m_aParentResolver;

    public SimpleLSResourceResolver() {
        this(null);
    }

    public SimpleLSResourceResolver(@Nullable LSResourceResolver lSResourceResolver) {
        this.m_aParentResolver = lSResourceResolver;
    }

    @Nonnull
    public static final IReadableResource doStandardResourceResolving(@Nonnull String string, @Nonnull String string2) throws IOException {
        URL uRL;
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Trying to resolve resource " + string + " from base " + string2);
        }
        if ((uRL = URLUtils.getAsURL(string)) != null && !uRL.getProtocol().equals("file")) {
            return new URLResource(uRL);
        }
        if (StringHelper.startsWith((CharSequence)string2, "jar:file:")) {
            File file;
            String string3;
            int n = string2.indexOf(33);
            String string4 = string3 = n < 0 ? string2 : string2.substring(n + 1);
            if (FilenameHelper.startsWithPathSeparatorChar(string3)) {
                string3 = string3.substring(1);
            }
            String string5 = FilenameHelper.getCleanPath((file = new File(string3).getParentFile()) == null ? string : file.getPath() + '/' + string);
            return new ClassPathResource(string5);
        }
        if (ClassPathResource.isExplicitClassPathResource(string2)) {
            String string6 = ClassPathResource.getWithoutClassPathPrefix(string2);
            File file = new File(string6).getParentFile();
            return new ClassPathResource(FilenameHelper.getCleanConcatenatedUrlPath(file == null ? "/" : file.getPath(), string));
        }
        URL uRL2 = URLUtils.getAsURL(string2);
        if (uRL2 != null && !uRL2.getProtocol().equals("file")) {
            return new URLResource(FilenameHelper.getCleanConcatenatedUrlPath(string2, string));
        }
        File file = uRL2 != null ? URLResource.getAsFile(uRL2) : new File(string2);
        if (StringHelper.hasNoText(string)) {
            return new FileSystemResource(file);
        }
        File file2 = uRL != null ? URLResource.getAsFile(uRL) : new File(string);
        File file3 = file.getParentFile();
        File file4 = new File(file3, file2.getPath());
        return new FileSystemResource(file4);
    }

    @Nullable
    @OverrideOnDemand
    protected IReadableResource internalResolveResource(@Nonnull String string, @Nonnull String string2) throws Exception {
        return SimpleLSResourceResolver.doStandardResourceResolving(string, string2);
    }

    @Override
    @Nullable
    public final LSInput resolveResource(String string, String string2, String string3, @Nonnull String string4, @Nonnull String string5) {
        try {
            IReadableResource iReadableResource = this.internalResolveResource(string4, string5);
            if (iReadableResource != null) {
                return new ResourceLSInput(iReadableResource);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to resolve resource relative to '" + string5 + "'", exception);
        }
        return this.m_aParentResolver == null ? null : this.m_aParentResolver.resolveResource(string, string2, string3, string4, string5);
    }
}

