/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.namespace;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.multimap.IMultiMapSetBased;
import com.phloc.commons.collections.multimap.MultiHashMapHashSetBased;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.AbstractNamespaceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedNamespaceContext
extends AbstractNamespaceContext {
    private String m_sDefaultNamespaceURI;
    private final Map<String, String> m_aPrefix2NS = new HashMap<String, String>();
    private final IMultiMapSetBased<String, String> m_aNS2Prefix = new MultiHashMapHashSetBased<String, String>();

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sDefaultNamespaceURI;
    }

    @Nonnull
    public MapBasedNamespaceContext setDefaultNamespaceURI(@Nonnull @Nonempty String string) {
        return this.addMapping("", string);
    }

    @Nonnull
    public MapBasedNamespaceContext addMapping(@Nonnull String string, @Nonnull @Nonempty String string2) {
        if (string == null) {
            throw new IllegalArgumentException("prefix may not be null");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("namespaceURI may not be empty");
        }
        if (this.m_aPrefix2NS.containsKey(string)) {
            throw new IllegalArgumentException("The prefix '" + string + "' is already registered!");
        }
        if (string.equals("")) {
            this.m_sDefaultNamespaceURI = string2;
        }
        this.m_aPrefix2NS.put(string, string2);
        this.m_aNS2Prefix.putSingle(string2, string);
        return this;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nonnull String string) {
        Set set = (Set)this.m_aNS2Prefix.get(string);
        return set == null ? null : set.iterator();
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nonnull String string) {
        Set set = (Set)this.m_aNS2Prefix.get(string);
        return (String)ContainerHelper.getFirstElement(set);
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nonnull String string) {
        return this.m_aPrefix2NS.get(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getPrefixToNamespaceURIMap() {
        return ContainerHelper.newMap(this.m_aPrefix2NS);
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("defaultNS", this.m_sDefaultNamespaceURI).append("prefix2NS", this.m_aPrefix2NS).append("ns2Prefix2", this.m_aNS2Prefix).toString();
    }
}

