/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.schema;

import com.phloc.commons.annotations.IsLocked;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.cache.AbstractNotifyingCache;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@ThreadSafe
public abstract class DefaultSchemaCache
extends AbstractNotifyingCache<List<? extends IReadableResource>, Schema> {
    private final String m_sSchemaTypeName;
    private final SchemaFactory m_aSchemaFactory;
    private final ErrorHandler m_aErrorHandler;

    public DefaultSchemaCache(@Nonnull String string, @Nonnull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super(DefaultSchemaCache.class.getName() + "$" + string);
        if (schemaFactory == null) {
            throw new NullPointerException("SchemaFactory");
        }
        this.m_sSchemaTypeName = string;
        this.m_aSchemaFactory = schemaFactory;
        this.m_aSchemaFactory.setErrorHandler(errorHandler);
        this.m_aSchemaFactory.setResourceResolver(lSResourceResolver);
        this.m_aErrorHandler = errorHandler;
    }

    @Override
    @Nonnull
    @IsLocked(value=IsLocked.ELockType.WRITE)
    protected Schema getValueToCache(@Nullable List<? extends IReadableResource> list) {
        if (ContainerHelper.isEmpty(list)) {
            throw new IllegalArgumentException("No resources provided!");
        }
        Object[] objectArray = new Source[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = TransformSourceFactory.create(list.get(i));
        }
        try {
            Schema schema = this.m_aSchemaFactory.newSchema((Source[])objectArray);
            if (schema == null) {
                throw new IllegalStateException("Failed to create " + this.m_sSchemaTypeName + " schema from " + Arrays.toString(objectArray));
            }
            return schema;
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("Failed to parse " + this.m_sSchemaTypeName + " from " + Arrays.toString(objectArray), sAXException);
        }
    }

    @Nonnull
    public final Schema getSchema(@Nonnull IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            throw new NullPointerException("resources");
        }
        return (Schema)this.getFromCache(ContainerHelper.newList(iReadableResource));
    }

    @Nonnull
    public final Schema getSchema(IReadableResource ... iReadableResourceArray) {
        if (ArrayHelper.isEmpty(iReadableResourceArray)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        if (ArrayHelper.containsAnyNullElement(iReadableResourceArray)) {
            throw new IllegalArgumentException("At leaste one resource is null!");
        }
        return (Schema)this.getFromCache(ContainerHelper.newList(iReadableResourceArray));
    }

    @Nonnull
    public final Schema getSchema(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        if (ContainerHelper.isEmpty(collection)) {
            throw new IllegalArgumentException("no resources provided!");
        }
        if (ContainerHelper.containsAnyNullElement(collection)) {
            throw new IllegalArgumentException("At leaste one resource is null!");
        }
        return (Schema)this.getFromCache(ContainerHelper.newList(collection));
    }

    @Nonnull
    public final Validator getValidatorFromSchema(@Nonnull Schema schema) {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(this.m_aErrorHandler);
        return validator;
    }

    @Nonnull
    public final Validator getValidator(@Nonnull IReadableResource iReadableResource) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResource));
    }

    @Nonnull
    public final Validator getValidator(IReadableResource ... iReadableResourceArray) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResourceArray));
    }

    @Nonnull
    public final Validator getValidator(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        return this.getValidatorFromSchema(this.getSchema(collection));
    }

    @Override
    @Nonnull
    public EChange removeFromCache(@Nullable IReadableResource iReadableResource) {
        return this.removeFromCache(ContainerHelper.newList(iReadableResource));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("schemaTypeName", this.m_sSchemaTypeName).toString();
    }
}

