/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.exceptions.InitializationException;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.pool.IObjectPool;
import com.phloc.commons.pool.ObjectPool;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.timing.StopWatch;
import com.phloc.commons.xml.EXMLParserFeature;
import com.phloc.commons.xml.EXMLParserProperty;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.sax.InputSourceFactory;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XMLReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLReader.class);
    private static final IStatisticsHandlerTimer s_aSaxTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$SAX");
    private static final IStatisticsHandlerCounter s_aSaxErrorCounterHdl = StatisticsManager.getCounterHandler(XMLReader.class.getName() + "$SAXERRORS");
    private static final IStatisticsHandlerTimer s_aDomTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOM");
    private static final IStatisticsHandlerTimer s_aDomSchemaTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOMwithSchema");
    private static final IStatisticsHandlerCounter s_aDomErrorCounterHdl = StatisticsManager.getCounterHandler(XMLReader.class.getName() + "$DOMERRORS");
    private static final IFactory<org.xml.sax.XMLReader> s_aXMLReaderFactry = new IFactory<org.xml.sax.XMLReader>(){

        @Override
        public org.xml.sax.XMLReader create() {
            try {
                org.xml.sax.XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setErrorHandler(LoggingSAXErrorHandler.getInstance());
                return xMLReader;
            }
            catch (SAXException sAXException) {
                throw new InitializationException("Failed to instantiate XML reader!", sAXException);
            }
        }
    };
    private static final IObjectPool<org.xml.sax.XMLReader> s_aPool = new ObjectPool<org.xml.sax.XMLReader>(5, s_aXMLReaderFactry);
    private static final Map<EXMLParserFeature, Boolean> s_aDefaultSaxParserFeatures = new EnumMap<EXMLParserFeature, Boolean>(EXMLParserFeature.class){
        {
            this.put(EXMLParserFeature.NAMESPACES, Boolean.TRUE);
            this.put(EXMLParserFeature.SAX_NAMESPACE_PREFIXES, Boolean.TRUE);
            this.put(EXMLParserFeature.AUGMENT_PSVI, Boolean.FALSE);
        }
    };
    private static final XMLReader s_aInstance = new XMLReader();

    private XMLReader() {
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource) throws SAXException {
        return XMLReader.readXMLDOM(inputSource, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream) throws SAXException {
        return XMLReader.readXMLDOM(inputStream, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file) throws SAXException {
        return XMLReader.readXMLDOM(file, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource) throws SAXException {
        return XMLReader.readXMLDOM(iReadableResource, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader) throws SAXException {
        return XMLReader.readXMLDOM(reader, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string) throws SAXException {
        return XMLReader.readXMLDOM(string, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray) throws SAXException {
        return XMLReader.readXMLDOM(byArray, (Schema)null, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(inputSource, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputStream inputStream, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(inputStream, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(file, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(iReadableResource, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(reader, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(string, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nullable Schema schema) throws SAXException {
        return XMLReader.readXMLDOM(byArray, schema, (ErrorHandler)null, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(inputSource, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputStream inputStream, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(inputStream, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(file, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(iReadableResource, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(reader, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(string, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(byArray, (Schema)null, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(inputSource, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(inputStream, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(file, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(iReadableResource, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose Reader reader, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(reader, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(string, schema, errorHandler, (EntityResolver)null);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nullable Schema schema, @Nullable ErrorHandler errorHandler) throws SAXException {
        return XMLReader.readXMLDOM(byArray, schema, errorHandler, (EntityResolver)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            StopWatch stopWatch = new StopWatch(true);
            DocumentBuilder documentBuilder2 = documentBuilder = schema == null ? XMLFactory.getDocumentBuilder() : XMLFactory.createDocumentBuilder(schema);
            CollectingSAXErrorHandler collectingSAXErrorHandler = errorHandler instanceof CollectingSAXErrorHandler ? (CollectingSAXErrorHandler)errorHandler : new CollectingSAXErrorHandler(errorHandler != null ? errorHandler : LoggingSAXErrorHandler.getInstance());
            documentBuilder.setErrorHandler(collectingSAXErrorHandler);
            documentBuilder.setEntityResolver(entityResolver);
            document = documentBuilder.parse(inputSource);
            if (schema == null) {
                s_aDomTimerHdl.addTime(stopWatch.stopAndGetMillis());
            } else {
                s_aDomSchemaTimerHdl.addTime(stopWatch.stopAndGetMillis());
            }
            if (collectingSAXErrorHandler.getResourceErrors().containsAtLeastOneError()) {
                Document document2 = null;
                return document2;
            }
        }
        catch (SAXException sAXException) {
            s_aLogger.error("Invalid XML document", (Throwable)sAXException);
            s_aDomErrorCounterHdl.increment();
            throw sAXException;
        }
        catch (IOException iOException) {
            s_aLogger.error("Error reading XML document", (Throwable)iOException);
            s_aDomErrorCounterHdl.increment();
        }
        finally {
            StreamUtils.close(inputSource.getByteStream());
            StreamUtils.close(inputSource.getCharacterStream());
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(inputStream), schema, errorHandler, entityResolver);
            return document;
        }
        finally {
            StreamUtils.close(inputStream);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(file), schema, errorHandler, entityResolver);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (iReadableResource == null) {
            throw new NullPointerException("resource");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(iReadableResource), schema, errorHandler, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose Reader reader, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(reader), schema, errorHandler, entityResolver);
            return document;
        }
        finally {
            StreamUtils.close(reader);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (string == null) {
            throw new NullPointerException("xml");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(string), schema, errorHandler, entityResolver);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nullable Schema schema, @Nullable ErrorHandler errorHandler, @Nullable EntityResolver entityResolver) throws SAXException {
        if (byArray == null) {
            throw new NullPointerException("xml");
        }
        return XMLReader.readXMLDOM(InputSourceFactory.create(byArray), schema, errorHandler, entityResolver);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputStream inputStream, EntityResolver entityResolver, DTDHandler dTDHandler, ContentHandler contentHandler, ErrorHandler errorHandler, @Nullable LexicalHandler lexicalHandler, boolean bl, boolean bl2) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        return XMLReader.readXMLSAX(InputSourceFactory.create(inputStream), entityResolver, dTDHandler, contentHandler, errorHandler, lexicalHandler, bl, bl2);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource inputSource, EntityResolver entityResolver, DTDHandler dTDHandler, ContentHandler contentHandler, ErrorHandler errorHandler, @Nullable LexicalHandler lexicalHandler, boolean bl, boolean bl2) {
        EnumMap<EXMLParserFeature, Boolean> enumMap = new EnumMap<EXMLParserFeature, Boolean>(s_aDefaultSaxParserFeatures);
        enumMap.put(EXMLParserFeature.VALIDATION, bl);
        enumMap.put(EXMLParserFeature.SCHEMA, bl2);
        enumMap.put(EXMLParserFeature.WARN_ON_DUPLICATE_ATTDEF, bl || bl2);
        enumMap.put(EXMLParserFeature.WARN_ON_DUPLICATE_ENTITYDEF, bl || bl2);
        return XMLReader.readXMLSAX(inputSource, entityResolver, dTDHandler, contentHandler, errorHandler, lexicalHandler, enumMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource inputSource, EntityResolver entityResolver, DTDHandler dTDHandler, ContentHandler contentHandler, ErrorHandler errorHandler, @Nullable LexicalHandler lexicalHandler, @Nullable Map<EXMLParserFeature, Boolean> map) {
        block20: {
            if (inputSource == null) {
                throw new NullPointerException("inputStream");
            }
            try {
                ESuccess eSuccess;
                org.xml.sax.XMLReader xMLReader = s_aPool.borrowObject();
                if (xMLReader == null) {
                    s_aLogger.error("Failed to get parser from pool!");
                    ESuccess eSuccess2 = ESuccess.FAILURE;
                    return eSuccess2;
                }
                try {
                    StopWatch stopWatch = new StopWatch(true);
                    xMLReader.setContentHandler(contentHandler);
                    xMLReader.setDTDHandler(dTDHandler);
                    xMLReader.setEntityResolver(entityResolver);
                    xMLReader.setErrorHandler(errorHandler);
                    if (map != null) {
                        for (Map.Entry<EXMLParserFeature, Boolean> entry : map.entrySet()) {
                            entry.getKey().applyTo(xMLReader, entry.getValue());
                        }
                    }
                    if (lexicalHandler != null) {
                        EXMLParserProperty.SAX_FEATURE_LEXICAL_HANDLER.applyTo(xMLReader, lexicalHandler);
                    }
                    xMLReader.parse(inputSource);
                    s_aSaxTimerHdl.addTime(stopWatch.stopAndGetMillis());
                    eSuccess = ESuccess.SUCCESS;
                    s_aPool.returnObject(xMLReader);
                }
                catch (Throwable throwable) {
                    try {
                        s_aPool.returnObject(xMLReader);
                        throw throwable;
                    }
                    catch (SAXParseException sAXParseException) {
                        s_aLogger.error("Error parsing XML at position (" + sAXParseException.getLineNumber() + "," + sAXParseException.getColumnNumber() + ")", (Throwable)sAXParseException);
                        break block20;
                    }
                    catch (SAXException sAXException) {
                        s_aLogger.error("Error parsing XML", (Throwable)sAXException);
                        break block20;
                    }
                    catch (UnknownHostException unknownHostException) {
                        s_aLogger.error("Failed to resolve entity host: " + unknownHostException.getMessage());
                        break block20;
                    }
                    catch (IOException iOException) {
                        s_aLogger.error("Error reading XML from input", (Throwable)iOException);
                        break block20;
                    }
                }
                return eSuccess;
            }
            finally {
                StreamUtils.close(inputSource.getByteStream());
                StreamUtils.close(inputSource.getCharacterStream());
            }
        }
        s_aSaxErrorCounterHdl.increment();
        return ESuccess.FAILURE;
    }

    @Nullable
    public static Boolean getDefaultSaxParserFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        return s_aDefaultSaxParserFeatures.get(eXMLParserFeature);
    }

    public static void setDefaultSaxParserFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        if (eXMLParserFeature == null) {
            throw new NullPointerException("feature");
        }
        if (bl == null) {
            s_aDefaultSaxParserFeatures.remove(eXMLParserFeature);
        } else {
            s_aDefaultSaxParserFeatures.put(eXMLParserFeature, bl);
        }
    }
}

