/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IOutputStreamProvider;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamResult;

@NotThreadSafe
public class ResourceStreamResult
extends StreamResult {
    private final IOutputStreamProvider m_aOSP;

    public ResourceStreamResult(@Nonnull IWritableResource iWritableResource) {
        this(iWritableResource, iWritableResource.getResourceID());
    }

    public ResourceStreamResult(@Nonnull IOutputStreamProvider iOutputStreamProvider, @Nullable String string) {
        if (iOutputStreamProvider == null) {
            throw new NullPointerException("resource");
        }
        this.m_aOSP = iOutputStreamProvider;
        this.setSystemId(string);
    }

    @Override
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.m_aOSP.getOutputStream(EAppend.TRUNCATE);
        if (outputStream == null) {
            throw new IllegalStateException("Failed to open output stream for " + this.m_aOSP);
        }
        return outputStream;
    }

    public String toString() {
        return new ToStringGenerator(this).append("OSP", this.m_aOSP).append("systemID", this.getSystemId()).toString();
    }
}

